/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.DocumentEntityImpl;
import org.datayoo.tripod.FieldMetadata;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.IdfCounter;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.bool.BoolOperand;
import org.datayoo.tripod.engine.TripodContextImpl;
import org.datayoo.tripod.engine.TripodListener;
import org.datayoo.tripod.factory.OperandFactory;
import org.datayoo.tripod.metadata.BoolMetadata;
import org.datayoo.tripod.parser.TripodExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripodEngine {
    protected static final Logger logger = LoggerFactory.getLogger(TripodEngine.class);
    protected TripodContextImpl tripodContext;
    protected Map<String, TripodRule> ruleMap = new HashMap<String, TripodRule>();
    protected ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public TripodEngine(List<FieldMetadata> allFields, FieldMetadata defaultFieldMetadata, IdfCounter idfCounter) {
        this.tripodContext = new TripodContextImpl(allFields, defaultFieldMetadata, idfCounter);
    }

    public TripodEngine setScoring(boolean scoring) {
        this.tripodContext.setScoring(scoring);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTripodRule(String name, String rule, TripodListener tripodListener) {
        Validate.notEmpty((CharSequence)name, (String)"name is empty!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)rule, (String)"rule is empty!", (Object[])new Object[0]);
        Validate.notNull((Object)tripodListener, (String)"tripodListener is null!", (Object[])new Object[0]);
        this.rwLock.writeLock().lock();
        try {
            if (this.ruleMap.get(name) != null) {
                throw new IllegalArgumentException(String.format("Name is conflicted!", new Object[0]));
            }
            BoolMetadata boolMetadata = TripodExpressionParser.parseFromString((String)rule);
            BoolOperand boolOperand = OperandFactory.createOperand(boolMetadata, this.tripodContext);
            TripodRule tripodRule = new TripodRule(name, rule);
            tripodRule.boolOperand = boolOperand;
            tripodRule.tripodListener = tripodListener;
            this.ruleMap.put(name, tripodRule);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeTripodRule(String name) {
        Validate.notEmpty((CharSequence)name, (String)"name is empty!", (Object[])new Object[0]);
        this.rwLock.writeLock().lock();
        try {
            TripodRule tripodRule = this.ruleMap.remove(name);
            if (tripodRule != null) {
                String string = name;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void match(Map<String, TermEntity[]> dataMap) {
        this.match(dataMap, true, false);
    }

    public void match(Map<String, TermEntity[]> dataMap, boolean termDistance) {
        this.match(dataMap, termDistance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void match(Map<String, TermEntity[]> dataMap, boolean termDistance, boolean retHit) {
        Validate.notEmpty(dataMap, (String)"dataMap is empty!", (Object[])new Object[0]);
        if (!this.checkDataMap(dataMap)) {
            return;
        }
        DocumentEntityImpl documentEntity = new DocumentEntityImpl(dataMap, this.tripodContext.isScoring());
        this.tripodContext.getIdfCounter().count(documentEntity.getAllTerms());
        this.rwLock.readLock().lock();
        try {
            for (TripodRule tripodRule : this.ruleMap.values()) {
                HashMap<String, List<HitToken>> hitMap = null;
                if (retHit) {
                    hitMap = new HashMap<String, List<HitToken>>();
                }
                try {
                    double score = tripodRule.boolOperand.operate(documentEntity, termDistance, hitMap);
                    if (!(score > 0.0)) continue;
                    tripodRule.tripodListener.onHit(tripodRule.name, dataMap, score, hitMap);
                }
                catch (Throwable t) {
                    logger.info(String.format("tripod rule '%s' execute failed!", tripodRule.name));
                }
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    protected boolean checkDataMap(Map<String, TermEntity[]> dataMap) {
        for (TermEntity[] termEntities : dataMap.values()) {
            if (termEntities == null || termEntities.length <= 0) continue;
            return true;
        }
        return false;
    }

    protected static class TripodRule {
        protected String name;
        protected String rule;
        protected BoolOperand boolOperand;
        protected TripodListener tripodListener;

        public TripodRule(String name, String rule) {
            this.name = name;
            this.rule = rule;
        }
    }
}

