/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.engine;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.FieldMetadata;
import org.datayoo.tripod.IdfCounter;
import org.datayoo.tripod.TripodContext;

public class TripodContextImpl
implements TripodContext {
    protected List<FieldMetadata> allFields;
    protected FieldMetadata defaultFieldMetadata;
    protected boolean scoring = false;
    protected IdfCounter idfCounter;

    public TripodContextImpl(List<FieldMetadata> allFields, FieldMetadata defaultFieldMetadata, IdfCounter idfCounter) {
        Validate.notEmpty(allFields, (String)"allFields is empty!", (Object[])new Object[0]);
        Validate.notNull((Object)defaultFieldMetadata, (String)"defaultFieldMetadata is null!", (Object[])new Object[0]);
        Validate.notNull((Object)idfCounter, (String)"idfCounter is null!", (Object[])new Object[0]);
        this.allFields = allFields;
        this.defaultFieldMetadata = defaultFieldMetadata;
        this.idfCounter = idfCounter;
    }

    @Override
    public FieldMetadata getDefaultField() {
        return this.defaultFieldMetadata;
    }

    @Override
    public List<FieldMetadata> getAllFields() {
        return this.allFields;
    }

    @Override
    public int getBoost(String field) {
        for (FieldMetadata fm : this.allFields) {
            if (!fm.getField().equals(field)) continue;
            return fm.getBoost();
        }
        return 1;
    }

    @Override
    public boolean isScoring() {
        return this.scoring;
    }

    @Override
    public double getIdf(String term) {
        if (this.scoring) {
            return this.idfCounter.idf(term);
        }
        return 0.0;
    }

    public void setScoring(boolean scoring) {
        this.scoring = scoring;
    }

    @Override
    public void calcIdf(Set<String> terms) {
        if (this.scoring) {
            this.idfCounter.count(terms);
        }
    }

    @Override
    public IdfCounter getIdfCounter() {
        return this.idfCounter;
    }
}

