/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.comp;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;
import org.datayoo.tripod.metadata.SuffixMetadata;
import org.datayoo.tripod.metadata.TermMetadata;
import org.datayoo.tripod.operand.AtomOperand;
import org.datayoo.tripod.utils.LevDistance;

public class TermFuzzyOperand
extends AtomOperand {
    protected char[] termChars;
    protected double similarity;

    public TermFuzzyOperand(String field, SuffixMetadata suffixMetadata, TripodContext context) {
        super(field, (ExpressionMetadata)suffixMetadata, context);
        if (suffixMetadata.getExpressionType() != ExpressionType.FUZZY) {
            throw new IllegalArgumentException("suffixMetadata is not a fuzzy expression!");
        }
        TermMetadata termMetadata = (TermMetadata)suffixMetadata.getExpr();
        this.termChars = termMetadata.getTerm().toCharArray();
        this.boost = termMetadata.getBoost();
        this.similarity = suffixMetadata.getNumber().doubleValue();
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double score = 0.0;
        List<HitToken> hits = this.getHits(hitMap, this.field);
        for (TermEntity termEntity : documentEntity.getTermEntities(this.field)) {
            char[] dst = termEntity.getTerm().toCharArray();
            int d = LevDistance.lev(this.termChars, dst);
            double sim = 1.0 - (double)d * 1.0 / (double)Math.min(this.termChars.length, dst.length);
            if (!(sim >= this.similarity)) continue;
            if (hits == null) {
                return this.score(documentEntity, termEntity);
            }
            score += this.score(documentEntity, termEntity);
            HitToken hit = new HitToken(termEntity.getOffset(), termEntity.getOffset() + termEntity.getTerm().length());
            hit.setToken(termEntity.getTerm());
            hits.add(hit);
        }
        if (score == 0.0) {
            return -1.0;
        }
        return score;
    }
}

