/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.comp;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.PhraseMetadata;
import org.datayoo.tripod.metadata.RangeMetadata;
import org.datayoo.tripod.metadata.TermMetadata;
import org.datayoo.tripod.operand.AtomOperand;

public class RangeOperand
extends AtomOperand {
    protected boolean lInclude;
    protected String lStr;
    protected boolean rInclude;
    protected String rStr;

    public RangeOperand(String field, RangeMetadata rangeMetadata, TripodContext tripodContext) {
        super(field, (ExpressionMetadata)rangeMetadata, tripodContext);
        this.lInclude = rangeMetadata.islInclude();
        this.rInclude = rangeMetadata.isrInclude();
        this.lStr = this.getStr(rangeMetadata.getlExpr());
        this.rStr = this.getStr(rangeMetadata.getrExpr());
    }

    protected String getStr(ExpressionMetadata expressionMetadata) {
        if (expressionMetadata instanceof TermMetadata) {
            TermMetadata tm = (TermMetadata)expressionMetadata;
            return tm.getTerm();
        }
        if (expressionMetadata instanceof PhraseMetadata) {
            PhraseMetadata pm = (PhraseMetadata)expressionMetadata;
            return pm.getPhrase();
        }
        throw new IllegalArgumentException(String.format("Unsupported expression type %s!", expressionMetadata.getExpressionType()));
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double score = 0.0;
        List<HitToken> hits = this.getHits(hitMap, this.field);
        for (TermEntity termEntity : documentEntity.getTermEntities(this.field)) {
            if (!this.inRange(termEntity.getTerm())) continue;
            if (hits == null) {
                return this.score(documentEntity, termEntity) * (double)this.boost;
            }
            score += this.score(documentEntity, termEntity) * (double)this.boost;
            HitToken hit = new HitToken(termEntity.getOffset(), termEntity.getOffset() + termEntity.getTerm().length());
            hit.setToken(termEntity.getTerm());
            hits.add(hit);
        }
        if (score == 0.0) {
            return -1.0;
        }
        return score;
    }

    protected boolean inRange(String term) {
        int comp = term.compareTo(this.lStr);
        if (this.lInclude && comp == 0) {
            return true;
        }
        if (comp < 0) {
            return false;
        }
        comp = term.compareTo(this.rStr);
        if (this.rInclude && comp == 0) {
            return true;
        }
        return comp <= 0;
    }
}

