/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.bool;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.Operand;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.bool.MustNotOperand;
import org.datayoo.tripod.bool.MustOperand;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.operand.DecratorOperand;

public class BoolOperand
extends DecratorOperand {
    protected List<Operand> mustOperands = new LinkedList<Operand>();
    protected List<Operand> shouldOperands = new LinkedList<Operand>();

    public BoolOperand(List<Operand> operands, ExpressionMetadata expressionMetadata, TripodContext tripodContext) {
        super(operands, expressionMetadata, tripodContext);
        for (Operand operand : operands) {
            if (operand instanceof MustOperand || operand instanceof MustNotOperand) {
                this.mustOperands.add(operand);
                continue;
            }
            this.shouldOperands.add(operand);
        }
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double score = this.mustOperate(documentEntity, termDistance, hitMap);
        if (score < 0.0) {
            return score;
        }
        if (score > 0.0 && !this.context.isScoring()) {
            return score;
        }
        int overlap = this.mustOperands.size();
        for (Operand operand : this.shouldOperands) {
            double d = operand.operate(documentEntity, termDistance, hitMap);
            if (!(d > 0.0)) continue;
            if (this.context.isScoring()) {
                score += d;
                ++overlap;
                continue;
            }
            return 1.0;
        }
        if (score == 0.0) {
            return -1.0;
        }
        if (this.context.isScoring()) {
            return this.coord(overlap) * score;
        }
        return 1.0;
    }

    protected double mustOperate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double scoreSum = 0.0;
        for (Operand operand : this.mustOperands) {
            double d = operand.operate(documentEntity, termDistance, hitMap);
            if (d < 0.0) {
                return d;
            }
            scoreSum += d;
        }
        return scoreSum;
    }

    protected double coord(int overlap) {
        return (double)overlap * 1.0 / (double)(this.mustOperands.size() + this.shouldOperands.size());
    }
}

