/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ui;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.ui.DivObject;
import org.datavec.api.transform.ui.components.RenderableComponentLineChart;
import org.datavec.api.transform.ui.components.RenderableComponentTable;
import org.datavec.api.writable.Writable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;

public class HtmlSequencePlotting {
    private HtmlSequencePlotting() {
    }

    public static String createHtmlSequencePlots(String title, Schema schema, List<List<Writable>> sequence) throws Exception {
        int i;
        int i2;
        Configuration cfg = new Configuration(new Version(2, 3, 23));
        cfg.setClassForTemplateLoading(HtmlSequencePlotting.class, "/templates/");
        cfg.setIncompatibleImprovements(new Version(2, 3, 23));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setLocale(Locale.US);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("pagetitle", title);
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        ArrayList<DivObject> divs = new ArrayList<DivObject>();
        ArrayList<String> divNames = new ArrayList<String>();
        int n = schema.numColumns();
        String[][] table = new String[n / 2 + n % 2][6];
        List<ColumnMetaData> meta = schema.getColumnMetaData();
        for (i2 = 0; i2 < meta.size(); ++i2) {
            int o = i2 % 2;
            table[i2 / 2][o * 3] = String.valueOf(i2);
            table[i2 / 2][o * 3 + 1] = meta.get(i2).getName();
            table[i2 / 2][o * 3 + 2] = meta.get(i2).getColumnType().toString();
        }
        for (i2 = 0; i2 < table.length; ++i2) {
            for (int j = 0; j < table[i2].length; ++j) {
                if (table[i2][j] != null) continue;
                table[i2][j] = "";
            }
        }
        RenderableComponentTable rct = new RenderableComponentTable.Builder().table(table).header("#", "Name", "Type", "#", "Name", "Type").backgroundColor("#FFFFFF").headerColor("#CCCCCC").colWidthsPercent(8.0, 30.0, 12.0, 8.0, 30.0, 12.0).border(1).padLeftPx(4).padRightPx(4).build();
        divs.add(new DivObject("tablesource", ret.writeValueAsString((Object)rct)));
        double[] x = new double[sequence.size()];
        for (i = 0; i < x.length; ++i) {
            x[i] = i;
        }
        block8: for (i = 0; i < n; ++i) {
            double[] lineData;
            switch (meta.get(i).getColumnType()) {
                case Integer: 
                case Long: 
                case Double: 
                case Float: 
                case Time: {
                    lineData = new double[sequence.size()];
                    for (int j = 0; j < lineData.length; ++j) {
                        lineData[j] = sequence.get(j).get(i).toDouble();
                    }
                    break;
                }
                case Categorical: {
                    List<String> stateNames = ((CategoricalMetaData)meta.get(i)).getStateNames();
                    lineData = new double[sequence.size()];
                    for (int j = 0; j < lineData.length; ++j) {
                        String state = sequence.get(j).get(i).toString();
                        int idx = stateNames.indexOf(state);
                        lineData[j] = idx;
                    }
                    break;
                }
                default: {
                    continue block8;
                }
            }
            String name = meta.get(i).getName();
            String chartTitle = "Column: \"" + name + "\" - Column Type: " + (Object)((Object)meta.get(i).getColumnType());
            if (meta.get(i).getColumnType() == ColumnType.Categorical) {
                List<String> stateNames = ((CategoricalMetaData)meta.get(i)).getStateNames();
                StringBuilder sb = new StringBuilder(chartTitle);
                sb.append(" - (");
                for (int j = 0; j < stateNames.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    sb.append(j).append("=").append(stateNames.get(j));
                }
                sb.append(")");
                chartTitle = sb.toString();
            }
            RenderableComponentLineChart lc = new RenderableComponentLineChart.Builder().title(chartTitle).addSeries(name, x, lineData).build();
            String divname = "plot_" + i;
            divs.add(new DivObject(divname, ret.writeValueAsString((Object)lc)));
            divNames.add(divname);
        }
        input.put("divs", divs);
        input.put("divnames", divNames);
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss zzz").withZone(DateTimeZone.UTC);
        long currTime = System.currentTimeMillis();
        String dateTime = formatter.print(currTime);
        input.put("datetime", dateTime);
        Template template = cfg.getTemplate("sequenceplot.ftl");
        StringWriter stringWriter = new StringWriter();
        template.process(input, (Writer)stringWriter);
        return ((Object)stringWriter).toString();
    }

    public static void createHtmlSequencePlotFile(String title, Schema schema, List<List<Writable>> sequence, File output) throws Exception {
        String s = HtmlSequencePlotting.createHtmlSequencePlots(title, schema, sequence);
        FileUtils.writeStringToFile((File)output, (String)s, (Charset)StandardCharsets.UTF_8);
    }
}

