/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.split;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.sequence.SequenceSplit;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema"})
public class SplitMaxLengthSequence
implements SequenceSplit {
    private final int maxSequenceLength;
    private final boolean equalSplits;
    private Schema inputSchema;

    public SplitMaxLengthSequence(@JsonProperty(value="maxSequenceLength") int maxSequenceLength, @JsonProperty(value="equalSplits") boolean equalSplits) {
        this.maxSequenceLength = maxSequenceLength;
        this.equalSplits = equalSplits;
    }

    @Override
    public List<List<List<Writable>>> split(List<List<Writable>> sequence) {
        int n = sequence.size();
        if (n <= this.maxSequenceLength) {
            return Collections.singletonList(sequence);
        }
        int splitSize = this.equalSplits ? (n % this.maxSequenceLength == 0 ? n / this.maxSequenceLength : n / this.maxSequenceLength + 1) : this.maxSequenceLength;
        ArrayList<List<List<Writable>>> out = new ArrayList<List<List<Writable>>>();
        ArrayList<List<Writable>> current = new ArrayList<List<Writable>>(splitSize);
        for (List<Writable> step : sequence) {
            if (current.size() >= splitSize) {
                out.add(current);
                current = new ArrayList(splitSize);
            }
            current.add(step);
        }
        out.add(current);
        return out;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public String toString() {
        return "SplitMaxLengthSequence(maxSequenceLength=" + this.maxSequenceLength + ",equalSplits=" + this.equalSplits + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitMaxLengthSequence)) {
            return false;
        }
        SplitMaxLengthSequence other = (SplitMaxLengthSequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSequenceLength() != other.getMaxSequenceLength()) {
            return false;
        }
        return this.isEqualSplits() == other.isEqualSplits();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SplitMaxLengthSequence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxSequenceLength();
        result = result * 59 + (this.isEqualSplits() ? 79 : 97);
        return result;
    }

    public int getMaxSequenceLength() {
        return this.maxSequenceLength;
    }

    public boolean isEqualSplits() {
        return this.equalSplits;
    }
}

