/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ops;

import java.util.List;
import lombok.NonNull;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.ops.DispatchOp;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.guava.base.Preconditions;

public class DispatchWithConditionOp<U>
extends DispatchOp<Writable, U>
implements IAggregableReduceOp<List<Writable>, List<U>> {
    @NonNull
    private List<Condition> conditions;

    public DispatchWithConditionOp(List<IAggregableReduceOp<Writable, List<U>>> ops, List<Condition> conds) {
        super(ops);
        Preconditions.checkNotNull(conds, (Object)"Empty condtions for a DispatchWitConditionsOp, use DispatchOp instead");
        Preconditions.checkArgument((ops.size() == conds.size() ? 1 : 0) != 0, (Object)("Found conditions size " + conds.size() + " expected " + ops.size()));
        this.conditions = conds;
    }

    @Override
    public void accept(List<Writable> ts) {
        for (int i = 0; i < Math.min(super.getOperations().size(), ts.size()); ++i) {
            Condition cond = this.conditions.get(i);
            if (!cond.condition(ts)) continue;
            super.getOperations().get(i).accept(ts.get(i));
        }
    }

    @NonNull
    public List<Condition> getConditions() {
        return this.conditions;
    }
}

