/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ops;

import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.UnsafeWritableInjector;
import org.datavec.api.writable.Writable;

public class AggregatorImpls {

    public static class AggregableCountUnique<T>
    implements IAggregableReduceOp<T, Writable> {
        private float p = 0.05f;
        private HyperLogLogPlus hll = new HyperLogLogPlus((int)Math.ceil(2.0 * Math.log(1.054 / (double)this.p) / Math.log(2.0)), 0);

        public AggregableCountUnique(float precision) {
            this.p = precision;
        }

        public void accept(T element) {
            this.hll.offer(element);
        }

        @Override
        public <U extends IAggregableReduceOp<T, Writable>> void combine(U acc) {
            if (acc instanceof AggregableCountUnique) {
                try {
                    this.hll.addAll(((AggregableCountUnique)acc).getHll());
                }
                catch (CardinalityMergeException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + acc.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
        }

        public Writable get() {
            return new LongWritable(this.hll.cardinality());
        }

        public AggregableCountUnique() {
        }

        public HyperLogLogPlus getHll() {
            return this.hll;
        }
    }

    public static class AggregablePopulationVariance<T extends Number>
    extends AggregableVariance<T> {
        @Override
        public Writable get() {
            return new DoubleWritable(this.getVariation() / (double)this.getCount().longValue());
        }
    }

    public static class AggregableVariance<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private Long count = 0L;
        private Double mean = 0.0;
        private Double variation = 0.0;

        public void accept(T n) {
            if (this.count == 0L) {
                this.count = 1L;
                this.mean = ((Number)n).doubleValue();
                this.variation = 0.0;
            } else {
                Long newCount = this.count + 1L;
                Double newMean = this.mean + (((Number)n).doubleValue() - this.mean) / (double)newCount.longValue();
                Double newvariation = this.variation + (((Number)n).doubleValue() - this.mean) * (((Number)n).doubleValue() - newMean);
                this.count = newCount;
                this.mean = newMean;
                this.variation = newvariation;
            }
        }

        @Override
        public <U extends IAggregableReduceOp<T, Writable>> void combine(U acc) {
            if (!this.getClass().isAssignableFrom(acc.getClass())) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + acc.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
            AggregableVariance accu = (AggregableVariance)acc;
            Long totalCount = this.count + accu.getCount();
            Double totalMean = (accu.getMean() * (double)accu.getCount().longValue() + this.mean * (double)this.count.longValue()) / (double)totalCount.longValue();
            Double variance = this.variation / (double)(this.count - 1L);
            Double otherVariance = accu.getVariation() / (double)(accu.getCount() - 1L);
            Double totalVariation = (variance + otherVariance) * (double)(totalCount - 1L);
            this.count = totalCount;
            this.mean = totalMean;
            this.variation = this.variation;
        }

        public Writable get() {
            return new DoubleWritable(this.variation / (double)(this.count - 1L));
        }

        public Long getCount() {
            return this.count;
        }

        public Double getMean() {
            return this.mean;
        }

        public Double getVariation() {
            return this.variation;
        }
    }

    public static class AggregableUncorrectedStdDev<T extends Number>
    extends AggregableStdDev<T> {
        @Override
        public Writable get() {
            return new DoubleWritable(Math.sqrt(this.getVariation() / (double)this.getCount().longValue()));
        }
    }

    public static class AggregableStdDev<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private Long count = 0L;
        private Double mean = 0.0;
        private Double variation = 0.0;

        public void accept(T n) {
            if (this.count == 0L) {
                this.count = 1L;
                this.mean = ((Number)n).doubleValue();
                this.variation = 0.0;
            } else {
                Long newCount = this.count + 1L;
                Double newMean = this.mean + (((Number)n).doubleValue() - this.mean) / (double)newCount.longValue();
                Double newvariation = this.variation + (((Number)n).doubleValue() - this.mean) * (((Number)n).doubleValue() - newMean);
                this.count = newCount;
                this.mean = newMean;
                this.variation = newvariation;
            }
        }

        @Override
        public <U extends IAggregableReduceOp<T, Writable>> void combine(U acc) {
            if (!this.getClass().isAssignableFrom(acc.getClass())) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + acc.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
            AggregableStdDev accu = (AggregableStdDev)acc;
            Long totalCount = this.count + accu.getCount();
            Double totalMean = (accu.getMean() * (double)accu.getCount().longValue() + this.mean * (double)this.count.longValue()) / (double)totalCount.longValue();
            Double variance = this.variation / (double)(this.count - 1L);
            Double otherVariance = accu.getVariation() / (double)(accu.getCount() - 1L);
            Double totalVariation = (variance + otherVariance) * (double)(totalCount - 1L);
            this.count = totalCount;
            this.mean = totalMean;
            this.variation = this.variation;
        }

        public Writable get() {
            return new DoubleWritable(Math.sqrt(this.variation / (double)(this.count - 1L)));
        }

        public Long getCount() {
            return this.count;
        }

        public Double getMean() {
            return this.mean;
        }

        public Double getVariation() {
            return this.variation;
        }
    }

    public static class AggregableMean<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private Long count = 0L;
        private Double mean = 0.0;

        public void accept(T n) {
            if (this.count == 0L) {
                this.count = 1L;
                this.mean = ((Number)n).doubleValue();
            } else {
                this.count = this.count + 1L;
                this.mean = this.mean + (((Number)n).doubleValue() - this.mean) / (double)this.count.longValue();
            }
        }

        @Override
        public <U extends IAggregableReduceOp<T, Writable>> void combine(U acc) {
            if (!(acc instanceof AggregableMean)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + acc.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
            Long cnt = ((AggregableMean)acc).getCount();
            Long newCount = this.count + cnt;
            this.mean = (this.mean * (double)this.count.longValue() + ((Writable)acc.get()).toDouble() * (double)cnt.longValue()) / (double)newCount.longValue();
            this.count = newCount;
        }

        public Writable get() {
            return new DoubleWritable(this.mean);
        }

        public Long getCount() {
            return this.count;
        }
    }

    public static class AggregableCount<T>
    implements IAggregableReduceOp<T, Writable> {
        private Long count = 0L;

        public void accept(T element) {
            this.count = this.count + 1L;
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            if (!(accu instanceof AggregableCount)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
            this.count = this.count + ((Writable)accu.get()).toLong();
        }

        public Writable get() {
            return new LongWritable(this.count);
        }
    }

    public static class AggregableRange<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private T min = null;
        private T max = null;

        public void accept(T element) {
            if (this.min == null || ((Comparable)this.min).compareTo(element) > 0) {
                this.min = element;
            }
            if (this.max == null || ((Comparable)this.max).compareTo(element) < 0) {
                this.max = element;
            }
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            if (this.max == null || accu instanceof AggregableRange && ((Comparable)this.max).compareTo(((AggregableRange)accu).getMax()) < 0) {
                this.max = ((AggregableRange)accu).getMax();
            }
            if (this.min == null || accu instanceof AggregableRange && ((Comparable)this.min).compareTo(((AggregableRange)accu).getMin()) > 0) {
                this.min = ((AggregableRange)accu).getMin();
            }
            if (!(accu instanceof AggregableRange)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
        }

        public Writable get() {
            if (this.min.getClass() == Long.class) {
                return UnsafeWritableInjector.inject(((Number)this.max).longValue() - ((Number)this.min).longValue());
            }
            if (this.min.getClass() == Integer.class) {
                return UnsafeWritableInjector.inject(((Number)this.max).intValue() - ((Number)this.min).intValue());
            }
            if (this.min.getClass() == Float.class) {
                return UnsafeWritableInjector.inject(Float.valueOf(((Number)this.max).floatValue() - ((Number)this.min).floatValue()));
            }
            if (this.min.getClass() == Double.class) {
                return UnsafeWritableInjector.inject(((Number)this.max).doubleValue() - ((Number)this.min).doubleValue());
            }
            if (this.min.getClass() == Byte.class) {
                return UnsafeWritableInjector.inject(((Number)this.max).byteValue() - ((Number)this.min).byteValue());
            }
            throw new IllegalArgumentException("Wrong type for Aggregable Range operation " + this.min.getClass().getName());
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }
    }

    public static class AggregableMin<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private T min = null;

        public void accept(T element) {
            if (this.min == null || ((Comparable)this.min).compareTo(element) > 0) {
                this.min = element;
            }
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            if (this.min == null || accu instanceof AggregableMin && ((Comparable)this.min).compareTo(((AggregableMin)accu).getMin()) > 0) {
                this.min = ((AggregableMin)accu).getMin();
            } else if (!(accu instanceof AggregableMin)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
        }

        public Writable get() {
            return UnsafeWritableInjector.inject(this.min);
        }

        public T getMin() {
            return this.min;
        }
    }

    public static class AggregableMax<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private T max = null;

        public void accept(T element) {
            if (this.max == null || ((Comparable)this.max).compareTo(element) < 0) {
                this.max = element;
            }
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            if (this.max == null || accu instanceof AggregableMax && ((Comparable)this.max).compareTo(((AggregableMax)accu).getMax()) < 0) {
                this.max = ((AggregableMax)accu).getMax();
            } else if (!(accu instanceof AggregableMax)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
        }

        public Writable get() {
            return UnsafeWritableInjector.inject(this.max);
        }

        public T getMax() {
            return this.max;
        }
    }

    public static class AggregableProd<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private Number prod;
        private T initialElement;

        private static <U extends Number> Number multiplyNumbers(U a, U b) {
            if (a instanceof Double || b instanceof Double) {
                return new Double(a.doubleValue() * b.doubleValue());
            }
            if (a instanceof Float || b instanceof Float) {
                return new Float(a.floatValue() * b.floatValue());
            }
            if (a instanceof Long || b instanceof Long) {
                return new Long(a.longValue() * b.longValue());
            }
            return new Integer(a.intValue() * b.intValue());
        }

        public void accept(T element) {
            if (this.prod == null) {
                this.prod = element;
                this.initialElement = element;
            } else if (this.initialElement.getClass().isAssignableFrom(element.getClass())) {
                this.prod = AggregableProd.multiplyNumbers(this.prod, element);
            }
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            AggregableSum accumulator;
            if (accu instanceof AggregableSum) {
                accumulator = (AggregableSum)accu;
                if (accumulator.getInitialElement().getClass().isAssignableFrom(this.initialElement.getClass())) {
                    this.initialElement = accumulator.initialElement;
                }
            } else {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
            this.prod = AggregableProd.multiplyNumbers(this.prod, accumulator.getSum());
        }

        public Writable get() {
            return UnsafeWritableInjector.inject(this.prod);
        }

        public Number getProd() {
            return this.prod;
        }

        public T getInitialElement() {
            return this.initialElement;
        }
    }

    public static class AggregableSum<T extends Number>
    implements IAggregableReduceOp<T, Writable> {
        private Number sum;
        private T initialElement;

        private static <U extends Number> Number addNumbers(U a, U b) {
            if (a instanceof Double || b instanceof Double) {
                return new Double(a.doubleValue() + b.doubleValue());
            }
            if (a instanceof Float || b instanceof Float) {
                return new Float(a.floatValue() + b.floatValue());
            }
            if (a instanceof Long || b instanceof Long) {
                return new Long(a.longValue() + b.longValue());
            }
            return new Integer(a.intValue() + b.intValue());
        }

        public void accept(T element) {
            if (this.sum == null) {
                this.sum = element;
                this.initialElement = element;
            } else if (this.initialElement.getClass().isAssignableFrom(element.getClass())) {
                this.sum = AggregableSum.addNumbers(this.sum, element);
            }
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            AggregableSum accumulator;
            if (accu instanceof AggregableSum) {
                accumulator = (AggregableSum)accu;
                if (accumulator.getInitialElement().getClass().isAssignableFrom(this.initialElement.getClass())) {
                    this.initialElement = accumulator.initialElement;
                }
            } else {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
            this.sum = AggregableSum.addNumbers(this.sum, accumulator.getSum());
        }

        public Writable get() {
            return UnsafeWritableInjector.inject(this.sum);
        }

        public Number getSum() {
            return this.sum;
        }

        public T getInitialElement() {
            return this.initialElement;
        }
    }

    public static class AggregableLast<T>
    implements IAggregableReduceOp<T, Writable> {
        private T elem = null;
        private Writable override = null;

        public void accept(T element) {
            if (element != null) {
                this.elem = element;
            }
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            if (!(accu instanceof AggregableLast)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
            this.override = (Writable)accu.get();
        }

        public Writable get() {
            if (this.override == null) {
                return UnsafeWritableInjector.inject(this.elem);
            }
            return this.override;
        }
    }

    public static class AggregableFirst<T>
    implements IAggregableReduceOp<T, Writable> {
        private T elem = null;

        public void accept(T element) {
            if (this.elem == null) {
                this.elem = element;
            }
        }

        @Override
        public <W extends IAggregableReduceOp<T, Writable>> void combine(W accu) {
            if (!(accu instanceof IAggregableReduceOp)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where " + this.getClass().getName() + " expected");
            }
        }

        public Writable get() {
            return UnsafeWritableInjector.inject(this.elem);
        }
    }
}

