/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;

public class CategoricalAnalysis
implements ColumnAnalysis {
    private Map<String, Long> mapOfCounts;

    public String toString() {
        ArrayList<String> keys = new ArrayList<String>(this.mapOfCounts.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -Long.compare((Long)CategoricalAnalysis.this.mapOfCounts.get(o1), (Long)CategoricalAnalysis.this.mapOfCounts.get(o2));
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append("CategoricalAnalysis(CategoryCounts={");
        boolean first = true;
        for (String s : keys) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(s).append("=").append(this.mapOfCounts.get(s));
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public long getCountTotal() {
        Collection<Long> counts = this.mapOfCounts.values();
        long sum = 0L;
        for (Long l : counts) {
            sum += l.longValue();
        }
        return sum;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Categorical;
    }

    public CategoricalAnalysis(Map<String, Long> mapOfCounts) {
        this.mapOfCounts = mapOfCounts;
    }

    public Map<String, Long> getMapOfCounts() {
        return this.mapOfCounts;
    }

    public void setMapOfCounts(Map<String, Long> mapOfCounts) {
        this.mapOfCounts = mapOfCounts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoricalAnalysis)) {
            return false;
        }
        CategoricalAnalysis other = (CategoricalAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Long> this$mapOfCounts = this.getMapOfCounts();
        Map<String, Long> other$mapOfCounts = other.getMapOfCounts();
        return !(this$mapOfCounts == null ? other$mapOfCounts != null : !((Object)this$mapOfCounts).equals(other$mapOfCounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoricalAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Long> $mapOfCounts = this.getMapOfCounts();
        result = result * 59 + ($mapOfCounts == null ? 43 : ((Object)$mapOfCounts).hashCode());
        return result;
    }

    public CategoricalAnalysis() {
    }
}

