/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.OffsetTime;
import java.time.format.DateTimeParseException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class OffsetTimeStringConverter
implements TypeConverter<OffsetTime, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = 7774900007678148768L;

    @Override
    public OffsetTime toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return OffsetTime.parse(str);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, OffsetTime.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(OffsetTime time) {
        return time != null ? time.toString() : null;
    }

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 12;
    }
}

