/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.compiler.CompilationOptimiser;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class NavigationNullCompilationOptimiser
implements CompilationOptimiser {
    QueryCompilation compilation;
    MetaDataManager mmgr;
    ClassLoaderResolver clr;

    public NavigationNullCompilationOptimiser(QueryCompilation compilation, MetaDataManager mmgr, ClassLoaderResolver clr) {
        this.mmgr = mmgr;
        this.clr = clr;
        this.compilation = compilation;
    }

    @Override
    public void optimise() {
        this.processPrimaryExpressionNavigationNullCheck(this.compilation.getExprFilter());
    }

    private void processPrimaryExpressionNavigationNullCheck(Expression expr) {
        if (expr == null) {
            return;
        }
        if (expr instanceof DyadicExpression) {
            this.processPrimaryExpressionNavigationNullCheck(expr.getLeft());
            this.processPrimaryExpressionNavigationNullCheck(expr.getRight());
        } else if (expr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)expr;
            if (primExpr.getLeft() != null) {
                Expression left = primExpr.getLeft();
                this.processPrimaryExpressionNavigationNullCheck(left);
            } else {
                List<String> tuples = primExpr.getTuples();
                if (tuples.size() > 1) {
                    NucleusLogger.GENERAL.info(">> processPrimExpr " + primExpr + " tuples=" + StringUtils.collectionToString(tuples));
                }
            }
        } else if (expr instanceof InvokeExpression) {
            // empty if block
        }
    }

    protected boolean isPrimaryExpressionRelationNavigation(PrimaryExpression primExpr) {
        List<String> tuples = primExpr.getTuples();
        Iterator<String> tupleIter = tuples.iterator();
        String component = "";
        AbstractClassMetaData cmd = this.mmgr.getMetaDataForClass(this.compilation.candidateClass, this.clr);
        AbstractMemberMetaData mmd = null;
        while (tupleIter.hasNext()) {
            String name = tupleIter.next();
            if (component.length() == 0) {
                RelationType relType;
                if (!name.equals(this.compilation.candidateAlias) && RelationType.isRelationSingleValued(relType = (mmd = cmd.getMetaDataForMember(name)).getRelationType(this.clr))) {
                    AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(this.clr);
                    cmd = relMmds[0].getAbstractClassMetaData();
                    mmd = relMmds[0];
                }
                component = name;
            } else {
                if (cmd == null) {
                    return false;
                }
                if (mmd != null) {
                    // empty if block
                }
            }
            component = component + "." + name;
        }
        return false;
    }
}

