/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.Extent;

public class ExecutionContextThreadedImpl
extends ExecutionContextImpl {
    private Lock lock;

    public ExecutionContextThreadedImpl(PersistenceNucleusContext ctx, Object owner, Map<String, Object> options) {
        super(ctx, owner, options);
    }

    @Override
    public final Lock getLock() {
        if (this.lock == null) {
            this.lock = new ReentrantLock();
        }
        return this.lock;
    }

    @Override
    public boolean getMultithreaded() {
        return true;
    }

    @Override
    public void processNontransactionalUpdate() {
        try {
            this.getLock().lock();
            super.processNontransactionalUpdate();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void enlistInTransaction(ObjectProvider sm) {
        try {
            this.getLock().lock();
            super.enlistInTransaction(sm);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictFromTransaction(ObjectProvider sm) {
        try {
            this.getLock().lock();
            super.evictFromTransaction(sm);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void addObjectProviderToCache(ObjectProvider op) {
        try {
            this.getLock().lock();
            super.addObjectProviderToCache(op);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void removeObjectProviderFromCache(ObjectProvider op) {
        try {
            this.getLock().lock();
            super.removeObjectProviderFromCache(op);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public ObjectProvider findObjectProvider(Object pc) {
        try {
            this.getLock().lock();
            ObjectProvider objectProvider = super.findObjectProvider(pc);
            return objectProvider;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.getLock().lock();
            super.close();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictObject(Object obj) {
        try {
            this.getLock().lock();
            super.evictObject(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void refreshObject(Object obj) {
        try {
            this.getLock().lock();
            super.refreshObject(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void retrieveObject(Object obj, boolean fgOnly) {
        try {
            this.getLock().lock();
            super.retrieveObject(obj, fgOnly);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object persistObject(Object obj, boolean merging) {
        try {
            this.getLock().lock();
            Object object = super.persistObject(obj, merging);
            return object;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public Object[] persistObjects(Object ... objs) {
        try {
            this.getLock().lock();
            Object[] objectArray = super.persistObjects(objs);
            return objectArray;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void deleteObject(Object obj) {
        try {
            this.getLock().lock();
            super.deleteObject(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void deleteObjects(Object ... objs) {
        try {
            this.getLock().lock();
            super.deleteObjects(objs);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        try {
            this.getLock().lock();
            super.makeObjectTransient(obj, state);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void makeObjectTransactional(Object obj) {
        try {
            this.getLock().lock();
            super.makeObjectTransactional(obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachObject(ObjectProvider ownerOP, Object pc, boolean sco) {
        try {
            this.getLock().lock();
            super.attachObject(ownerOP, pc, sco);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attachObjectCopy(ObjectProvider ownerOP, Object pc, boolean sco) {
        try {
            this.getLock().lock();
            Object object = super.attachObjectCopy(ownerOP, pc, sco);
            return object;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void detachObject(FetchPlanState state, Object obj) {
        try {
            this.getLock().lock();
            super.detachObject(state, obj);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void detachObjects(FetchPlanState state, Object ... objs) {
        try {
            this.getLock().lock();
            super.detachObjects(state, objs);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        try {
            this.getLock().lock();
            Object object = super.detachObjectCopy(state, pc);
            return object;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void clearDirty(ObjectProvider op) {
        try {
            this.getLock().lock();
            super.clearDirty(op);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void clearDirty() {
        try {
            this.getLock().lock();
            super.clearDirty();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictAllObjects() {
        this.assertIsOpen();
        try {
            this.getLock().lock();
            super.evictAllObjects();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void markDirty(ObjectProvider op, boolean directUpdate) {
        try {
            this.getLock().lock();
            super.markDirty(op, directUpdate);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void flush() {
        try {
            this.getLock().lock();
            super.flush();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void flushInternal(boolean flushToDatastore) {
        try {
            this.getLock().lock();
            super.flushInternal(flushToDatastore);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceObjectId(Object pc, Object oldID, Object newID) {
        try {
            this.getLock().lock();
            super.replaceObjectId(pc, oldID, newID);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extent getExtent(Class pcClass, boolean subclasses) {
        try {
            this.getLock().lock();
            Extent extent = super.getExtent(pcClass, subclasses);
            return extent;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        try {
            this.getLock().lock();
            super.evictObjects(cls, subclasses);
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void refreshAllObjects() {
        try {
            this.getLock().lock();
            super.refreshAllObjects();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public List<ObjectProvider> getObjectsToBeFlushed() {
        try {
            this.getLock().lock();
            List<ObjectProvider> list = super.getObjectsToBeFlushed();
            return list;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void postBegin() {
        try {
            this.getLock().lock();
            super.postBegin();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void preCommit() {
        try {
            this.getLock().lock();
            super.preCommit();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void postCommit() {
        try {
            this.getLock().lock();
            super.postCommit();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void preRollback() {
        try {
            this.getLock().lock();
            super.preRollback();
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    public void postRollback() {
        try {
            this.getLock().lock();
            super.postRollback();
        }
        finally {
            this.getLock().unlock();
        }
    }
}

