/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.ClassConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ConnectionManager;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.federation.FederatedStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ConnectionManagerImpl
implements ConnectionManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    NucleusContext nucleusContext;
    Map<String, ConnectionFactory> factories = new HashMap<String, ConnectionFactory>();
    ManagedConnectionPool connectionPool = new ManagedConnectionPool();
    boolean connectionPoolEnabled = true;

    public ConnectionManagerImpl(NucleusContext context) {
        this.nucleusContext = context;
    }

    public void closeAllConnections(ConnectionFactory factory, ExecutionContext ec) {
        ManagedConnection mconnFromPool;
        if (ec != null && this.connectionPoolEnabled && (mconnFromPool = this.connectionPool.getManagedConnection(factory, ec)) != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug("Connection found in the pool : " + mconnFromPool + " for key=" + ec + " in factory=" + factory + " but owner object closing so closing connection");
            }
            mconnFromPool.close();
        }
    }

    public ManagedConnection allocateConnection(final ConnectionFactory factory, final ExecutionContext ec, Transaction transaction, Map options) {
        ManagedConnection mconnFromPool;
        if (ec != null && this.connectionPoolEnabled && (mconnFromPool = this.connectionPool.getManagedConnection(factory, ec)) != null) {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug("Connection found in the pool : " + mconnFromPool + " for key=" + ec + " in factory=" + factory);
            }
            if (!mconnFromPool.closeAfterTransactionEnd()) {
                if (transaction.isActive()) {
                    if (mconnFromPool.commitOnRelease()) {
                        mconnFromPool.setCommitOnRelease(false);
                    }
                    if (mconnFromPool.closeOnRelease()) {
                        mconnFromPool.setCloseOnRelease(false);
                    }
                    XAResource res = mconnFromPool.getXAResource();
                    org.datanucleus.transaction.Transaction tx = this.nucleusContext.getTransactionManager().getTransaction(ec);
                    if (res != null && !tx.isEnlisted(res)) {
                        boolean enlistInLocalTM = true;
                        if (options != null && options.get("resource-type") != null && ConnectionResourceType.JTA.toString().equalsIgnoreCase((String)options.get("resource-type"))) {
                            enlistInLocalTM = false;
                        }
                        if (enlistInLocalTM) {
                            tx.enlistResource(res);
                        }
                    }
                } else {
                    if (!mconnFromPool.commitOnRelease()) {
                        mconnFromPool.setCommitOnRelease(true);
                    }
                    if (mconnFromPool.closeOnRelease()) {
                        mconnFromPool.setCloseOnRelease(false);
                    }
                }
            }
            return mconnFromPool;
        }
        final ManagedConnection mconn = factory.createManagedConnection(ec, options == null && transaction != null ? transaction.getOptions() : options);
        if (ec != null) {
            if (transaction.isActive()) {
                this.configureTransactionEventListener(transaction, mconn);
                org.datanucleus.transaction.Transaction tx = this.nucleusContext.getTransactionManager().getTransaction(ec);
                mconn.setCommitOnRelease(false);
                mconn.setCloseOnRelease(false);
                XAResource res = mconn.getXAResource();
                if (res != null) {
                    boolean enlistInLocalTM = true;
                    if (options != null && options.get("resource-type") != null && ConnectionResourceType.JTA.toString().equalsIgnoreCase((String)options.get("resource-type"))) {
                        enlistInLocalTM = false;
                    }
                    if (enlistInLocalTM) {
                        tx.enlistResource(res);
                    }
                }
            }
            if (this.connectionPoolEnabled) {
                mconn.addListener(new ManagedConnectionResourceListener(){

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                    }

                    public void managedConnectionPreClose() {
                    }

                    public void managedConnectionPostClose() {
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug("Connection removed from the pool : " + mconn + " for key=" + ec + " in factory=" + factory);
                        }
                        ConnectionManagerImpl.this.connectionPool.removeManagedConnection(factory, ec);
                        mconn.removeListener(this);
                    }

                    public void resourcePostClose() {
                    }
                });
                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                    NucleusLogger.CONNECTION.debug("Connection added to the pool : " + mconn + " for key=" + ec + " in factory=" + factory);
                }
                this.connectionPool.putManagedConnection(factory, ec, mconn);
            }
        }
        return mconn;
    }

    private void configureTransactionEventListener(final Transaction transaction, final ManagedConnection mconn) {
        if (mconn.closeAfterTransactionEnd()) {
            transaction.addTransactionEventListener(new TransactionEventListener(){

                public void transactionStarted() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void transactionRolledBack() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void transactionCommitted() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void transactionEnded() {
                    try {
                        mconn.close();
                    }
                    finally {
                        transaction.removeTransactionEventListener(this);
                    }
                }

                public void transactionPreCommit() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(LOCALISER.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                public void transactionPreRollBack() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(LOCALISER.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                public void transactionPreFlush() {
                }

                public void transactionFlushed() {
                    mconn.transactionFlushed();
                }
            });
        } else {
            transaction.bindTransactionEventListener(new TransactionEventListener(){

                public void transactionStarted() {
                }

                public void transactionPreFlush() {
                }

                public void transactionFlushed() {
                    mconn.transactionFlushed();
                }

                public void transactionPreCommit() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(LOCALISER.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                public void transactionCommitted() {
                }

                public void transactionPreRollBack() {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(LOCALISER.msg("009000"));
                    }
                    mconn.transactionPreClose();
                }

                public void transactionRolledBack() {
                }

                public void transactionEnded() {
                }
            });
        }
    }

    public ConnectionFactory lookupConnectionFactory(String name) {
        return this.factories.get(name);
    }

    public void registerConnectionFactory(String name, ConnectionFactory factory) {
        this.factories.put(name, factory);
    }

    public void disableConnectionPool() {
        this.connectionPoolEnabled = false;
    }

    class PoolKey {
        ConnectionFactory factory;
        ExecutionContext ec;

        public PoolKey(ConnectionFactory factory, ExecutionContext ec) {
            this.factory = factory;
            this.ec = ec;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PoolKey)) {
                return false;
            }
            PoolKey other = (PoolKey)obj;
            return this.factory == other.factory && this.ec == other.ec;
        }

        public int hashCode() {
            return this.factory.hashCode() ^ this.ec.hashCode();
        }
    }

    class ManagedConnectionPool {
        Map<Object, Map<ConnectionFactory, ManagedConnection>> connectionsPool = new HashMap<Object, Map<ConnectionFactory, ManagedConnection>>();

        ManagedConnectionPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagedConnection(ConnectionFactory factory, ExecutionContext ec) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Object poolKey = this.getPoolKey(factory, ec);
                Map<ConnectionFactory, ManagedConnection> connectionsForPool = this.connectionsPool.get(poolKey);
                if (connectionsForPool != null) {
                    if (connectionsForPool.remove(factory) != null && ConnectionManagerImpl.this.nucleusContext.getStatistics() != null) {
                        ConnectionManagerImpl.this.nucleusContext.getStatistics().decrementActiveConnections();
                    }
                    if (connectionsForPool.size() == 0) {
                        this.connectionsPool.remove(poolKey);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedConnection getManagedConnection(ConnectionFactory factory, ExecutionContext ec) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Object poolKey = this.getPoolKey(factory, ec);
                Map<ConnectionFactory, ManagedConnection> connectionsForEC = this.connectionsPool.get(poolKey);
                if (connectionsForEC == null) {
                    return null;
                }
                ManagedConnection mconn = connectionsForEC.get(factory);
                if (mconn != null) {
                    if (mconn.isLocked()) {
                        throw new NucleusUserException(LOCALISER.msg("009000"));
                    }
                    return mconn;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putManagedConnection(ConnectionFactory factory, ExecutionContext ec, ManagedConnection mconn) {
            Map<Object, Map<ConnectionFactory, ManagedConnection>> map = this.connectionsPool;
            synchronized (map) {
                Object poolKey = this.getPoolKey(factory, ec);
                Map<ConnectionFactory, ManagedConnection> connectionsForOM = this.connectionsPool.get(poolKey);
                if (connectionsForOM == null) {
                    connectionsForOM = new HashMap<ConnectionFactory, ManagedConnection>();
                    this.connectionsPool.put(poolKey, connectionsForOM);
                }
                if (connectionsForOM.put(factory, mconn) == null && ConnectionManagerImpl.this.nucleusContext.getStatistics() != null) {
                    ConnectionManagerImpl.this.nucleusContext.getStatistics().incrementActiveConnections();
                }
            }
        }

        Object getPoolKey(ConnectionFactory factory, ExecutionContext ec) {
            if (ec.getStoreManager() instanceof FederatedStoreManager) {
                return new PoolKey(factory, ec);
            }
            return ec;
        }
    }
}

