/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.evaluator.memory;

import javax.jdo.JDOHelper;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.query.evaluator.memory.InvocationEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.util.Localiser;

public class JDOHelperGetVersionFunctionEvaluator
implements InvocationEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);

    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        Expression argExpr = expr.getArguments().get(0);
        if (argExpr instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)argExpr;
            Object value = eval.getValueForPrimaryExpression(primExpr);
            return JDOHelper.getVersion((Object)value);
        }
        if (argExpr instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)argExpr;
            Object value = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
            return JDOHelper.getVersion((Object)value);
        }
        throw new NucleusException("Dont currently support JDOHelper.getVersion with arg of type " + argExpr.getClass().getName());
    }
}

