/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.util.NucleusLogger;

public class L2CachePopulateFieldManager
extends AbstractFieldManager {
    ObjectProvider op;
    ExecutionContext ec;
    CachedPC cachedPC;

    public L2CachePopulateFieldManager(ObjectProvider op, CachedPC cachedpc) {
        this.op = op;
        this.ec = op.getExecutionContext();
        this.cachedPC = cachedpc;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeCharField(int fieldNumber, char value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Character.valueOf(value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeShortField(int fieldNumber, short value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeIntField(int fieldNumber, int value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeLongField(int fieldNumber, long value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, Float.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        this.cachedPC.setLoadedField(fieldNumber, true);
        this.cachedPC.setFieldValue(fieldNumber, value);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (!mmd.isCacheable()) {
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        ApiAdapter api = this.ec.getApiAdapter();
        this.cachedPC.setLoadedField(fieldNumber, true);
        if (value == null) {
            this.cachedPC.setFieldValue(fieldNumber, null);
            return;
        }
        if (api.isPersistable(value)) {
            if (!mmd.isSerialized() && !MetaDataUtils.isMemberEmbedded(mmd, mmd.getRelationType(this.ec.getClassLoaderResolver()), this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) {
                this.cachedPC.setFieldValue(fieldNumber, api.getIdForObject(value));
                return;
            }
            if (this.ec.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.cache.level2.cacheEmbedded")) {
                ObjectProvider objectProvider = this.ec.findObjectProvider(value);
                int[] loadedFields = objectProvider.getLoadedFieldNumbers();
                CachedPC cachedPC = new CachedPC(value.getClass(), objectProvider.getLoadedFields(), null);
                objectProvider.provideFields(loadedFields, new L2CachePopulateFieldManager(objectProvider, cachedPC));
                this.cachedPC.setFieldValue(fieldNumber, cachedPC);
                return;
            }
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (value instanceof Collection) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.ec)) {
                if (value instanceof List && mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getCollection().isSerializedElement() || mmd.getCollection().isEmbeddedElement()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                Collection collection = (Collection)value;
                if (collection instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                Iterator collIter = collection.iterator();
                Object var7_19 = null;
                try {
                    if (value.getClass().isInterface()) {
                        if (List.class.isAssignableFrom(value.getClass()) || mmd.getOrderMetaData() != null) {
                            ArrayList arrayList = new ArrayList();
                        } else {
                            HashSet hashSet = new HashSet();
                        }
                    } else if (value instanceof SCO) {
                        Collection collection2 = (Collection)((SCO)value).getValue().getClass().newInstance();
                    } else {
                        Collection collection3 = (Collection)value.getClass().newInstance();
                    }
                    while (true) {
                        void var7_24;
                        if (!collIter.hasNext()) {
                            this.cachedPC.setFieldValue(fieldNumber, var7_24);
                            return;
                        }
                        Object elem = collIter.next();
                        if (elem == null) {
                            var7_24.add(null);
                            continue;
                        }
                        var7_24.add(api.getIdForObject(elem));
                    }
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + e.getMessage());
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
            }
            if (!(value instanceof SCOContainer)) {
                this.cachedPC.setFieldValue(fieldNumber, value);
                return;
            }
            if (((SCOContainer)value).isLoaded()) {
                this.cachedPC.setFieldValue(fieldNumber, ((SCO)value).getValue());
                return;
            }
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (value instanceof Map) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.ec)) {
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getMap().isSerializedKey() || mmd.getMap().keyIsPersistent() && mmd.getMap().isEmbeddedKey() || mmd.getMap().isSerializedValue() || mmd.getMap().valueIsPersistent() && mmd.getMap().isEmbeddedValue()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                if (value instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
                try {
                    Object var5_7 = null;
                    if (value.getClass().isInterface()) {
                        HashMap hashMap = new HashMap();
                    } else if (value instanceof SCO) {
                        Map map = (Map)((SCO)value).getValue().getClass().newInstance();
                    } else {
                        Map map = (Map)value.getClass().newInstance();
                    }
                    Iterator mapIter = ((Map)value).entrySet().iterator();
                    while (true) {
                        void var5_11;
                        if (!mapIter.hasNext()) {
                            this.cachedPC.setFieldValue(fieldNumber, var5_11);
                            return;
                        }
                        Map.Entry entry = mapIter.next();
                        Object mapKey = null;
                        Object mapValue = null;
                        mapKey = mmd.getMap().keyIsPersistent() ? api.getIdForObject(entry.getKey()) : (Object)entry.getKey();
                        mapValue = mmd.getMap().valueIsPersistent() ? api.getIdForObject(entry.getValue()) : (Object)entry.getValue();
                        var5_11.put(mapKey, mapValue);
                    }
                }
                catch (Exception exception) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + exception.getMessage());
                    this.cachedPC.setLoadedField(fieldNumber, false);
                    return;
                }
            }
            if (!(value instanceof SCOContainer)) {
                this.cachedPC.setFieldValue(fieldNumber, value);
                return;
            }
            if (((SCOContainer)value).isLoaded()) {
                this.cachedPC.setFieldValue(fieldNumber, ((SCO)value).getValue());
                return;
            }
            this.cachedPC.setLoadedField(fieldNumber, false);
            return;
        }
        if (value instanceof Object[]) {
            if (!MetaDataUtils.getInstance().storesPersistable(mmd, this.ec)) {
                this.cachedPC.setFieldValue(fieldNumber, value);
                return;
            }
            if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getArray().isSerializedElement() || mmd.getArray().isEmbeddedElement()) {
                this.cachedPC.setLoadedField(fieldNumber, false);
                return;
            }
            Object[] objectArray = new Object[Array.getLength(value)];
            int i = 0;
            while (true) {
                if (i >= Array.getLength(value)) {
                    this.cachedPC.setFieldValue(fieldNumber, objectArray);
                    return;
                }
                Object object = Array.get(value, i);
                objectArray[i] = api.getIdForObject(object);
                ++i;
            }
        }
        if (value instanceof StringBuffer) {
            this.cachedPC.setFieldValue(fieldNumber, new StringBuffer((StringBuffer)value));
            return;
        }
        if (value instanceof SCO) {
            this.cachedPC.setFieldValue(fieldNumber, ((SCO)value).getValue());
            return;
        }
        this.cachedPC.setFieldValue(fieldNumber, value);
    }
}

