/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ExecutionContextImpl;
import org.datanucleus.FlushProcess;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlushNonReferential
implements FlushProcess {
    ExecutionContextImpl ec;

    public FlushNonReferential(ExecutionContextImpl ec) {
        this.ec = ec;
    }

    @Override
    public List<NucleusOptimisticException> execute(List<ObjectProvider> dirtyOPs, List<ObjectProvider> indirectDirtyOPs) {
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        HashSet<ObjectProvider> opsToFlush = new HashSet<ObjectProvider>();
        opsToFlush.addAll(dirtyOPs);
        dirtyOPs.clear();
        opsToFlush.addAll(indirectDirtyOPs);
        indirectDirtyOPs.clear();
        HashSet classesToFlush = null;
        if (this.ec.getNucleusContext().getStoreManager().getQueryManager().getQueryResultsCache() != null) {
            classesToFlush = new HashSet();
        }
        HashSet<ObjectProvider> opsToDelete = new HashSet<ObjectProvider>();
        HashSet<ObjectProvider> opsToInsert = new HashSet<ObjectProvider>();
        Iterator opIter = opsToFlush.iterator();
        while (opIter.hasNext()) {
            ObjectProvider op = (ObjectProvider)opIter.next();
            if (op.isEmbedded()) {
                op.markAsFlushed();
                opIter.remove();
                continue;
            }
            if (classesToFlush != null) {
                classesToFlush.add(op.getObject().getClass());
            }
            if (op.getLifecycleState().isNew() && !op.isFlushedToDatastore() && !op.isFlushedNew()) {
                opsToInsert.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isDeleted() || op.isFlushedToDatastore()) continue;
            if (!op.getLifecycleState().isNew()) {
                opsToDelete.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isNew() || !op.isFlushedNew()) continue;
            opsToDelete.add(op);
            opIter.remove();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010046", opsToDelete.size(), (Object)opsToInsert.size(), (Object)opsToFlush.size()));
        }
        StorePersistenceHandler persistenceHandler = this.ec.getStoreManager().getPersistenceHandler();
        if (!opsToDelete.isEmpty()) {
            for (ObjectProvider objectProvider : opsToDelete) {
                objectProvider.setFlushing(true);
                this.ec.getCallbackHandler().preDelete(objectProvider.getObject());
            }
            try {
                persistenceHandler.deleteObjects(opsToDelete.toArray(new ObjectProvider[opsToDelete.size()]));
            }
            catch (NucleusOptimisticException noe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList<NucleusOptimisticException>();
                }
                optimisticFailures.add(noe);
            }
            for (ObjectProvider objectProvider : opsToDelete) {
                this.ec.getCallbackHandler().postDelete(objectProvider.getObject());
                objectProvider.setFlushedNew(false);
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
            }
        }
        if (!opsToInsert.isEmpty()) {
            for (ObjectProvider objectProvider : opsToInsert) {
                objectProvider.setFlushing(true);
                this.ec.getCallbackHandler().preStore(objectProvider.getObject());
            }
            persistenceHandler.insertObjects(opsToInsert.toArray(new ObjectProvider[opsToInsert.size()]));
            for (ObjectProvider objectProvider : opsToInsert) {
                this.ec.getCallbackHandler().postStore(objectProvider.getObject());
                objectProvider.setFlushedNew(true);
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
                this.ec.putObjectIntoLevel1Cache(objectProvider);
            }
        }
        if (!opsToFlush.isEmpty()) {
            for (ObjectProvider objectProvider : opsToFlush) {
                try {
                    objectProvider.flush();
                }
                catch (NucleusOptimisticException oe) {
                    if (optimisticFailures == null) {
                        optimisticFailures = new ArrayList();
                    }
                    optimisticFailures.add(oe);
                }
            }
        }
        if (classesToFlush != null) {
            for (Class clazz : classesToFlush) {
                this.ec.getNucleusContext().getStoreManager().getQueryManager().evictQueryResultsForType(clazz);
            }
        }
        return optimisticFailures;
    }
}

