/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetPanel;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetSummary;
import org.gwtbootstrap3.client.shared.event.ShowEvent;
import org.gwtbootstrap3.client.shared.event.ShowHandler;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.constants.Toggle;

@Dependent
public class DataSetPanelView
extends Composite
implements DataSetPanel.View {
    private static DataSetPanelViewBinder uiBinder = (DataSetPanelViewBinder)GWT.create(DataSetPanelViewBinder.class);
    @UiField
    DataSetPanelViewStyle style;
    @UiField
    PanelHeader headerPanel;
    @UiField
    Image typeIcon;
    @UiField
    Heading title;
    @UiField
    PanelCollapse collapsePanel;
    @UiField
    PanelBody bodyPanel;
    @UiField(provided=true)
    DataSetSummary.View summaryView;
    @UiField
    Button actionButton;
    private DataSetPanel presenter;
    private HandlerRegistration actionButtonHandlerRegistration;

    public void init(DataSetPanel presenter) {
        this.presenter = presenter;
    }

    @Override
    public DataSetPanel.View configure(DataSetSummary.View summaryView) {
        this.summaryView = summaryView;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        return this;
    }

    @Override
    public DataSetPanel.View showHeader(String uuid, String parentCollapseId, SafeUri dataSetTypeImageUri, String dataSetTypeImageTitle, String dataSetTitle) {
        this.typeIcon.setUrl(dataSetTypeImageUri);
        this.typeIcon.setTitle(dataSetTypeImageTitle);
        this.typeIcon.setAltText(dataSetTypeImageTitle);
        this.title.setText(dataSetTitle);
        this.setDynamicToggleId(uuid, parentCollapseId);
        this.collapsePanel.addShowHandler(new ShowHandler(){

            public void onShow(ShowEvent shownEvent) {
                DataSetPanelView.this.presenter.open();
            }
        });
        return this;
    }

    private void setDynamicToggleId(String uuid, String parentCollapseId) {
        String tId = "collapsePanel" + uuid;
        this.collapsePanel.setId(tId);
        this.headerPanel.setDataToggle(Toggle.COLLAPSE);
        this.headerPanel.setDataTarget("#" + tId);
        this.headerPanel.setDataParent("#" + parentCollapseId);
    }

    @Override
    public DataSetPanel.View showSummary() {
        return this;
    }

    @Override
    public DataSetPanel.View hideSummary() {
        this.collapsePanel.setIn(false);
        return this;
    }

    @Override
    public DataSetPanel.View enableActionButton(String buttonTitle, ClickHandler clickHandler) {
        this.actionButton.setText(buttonTitle);
        this.actionButton.setEnabled(true);
        if (this.actionButtonHandlerRegistration != null) {
            this.actionButtonHandlerRegistration.removeHandler();
        }
        this.actionButtonHandlerRegistration = this.actionButton.addClickHandler(clickHandler);
        return this;
    }

    @Override
    public DataSetPanel.View disableActionButton() {
        this.actionButton.setEnabled(false);
        return this;
    }

    static interface DataSetPanelViewStyle
    extends CssResource {
    }

    static interface DataSetPanelViewBinder
    extends UiBinder<Widget, DataSetPanelView> {
    }
}

