/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.sql;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.list.DropDownEditor;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.def.SQLDataSourceDef;
import org.dashbuilder.dataset.service.SQLProviderServices;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.client.mvp.UberView;

@Dependent
public class SQLDataSetDefAttributesEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.SQLDataSetDefAttributesEditor {
    Caller<SQLProviderServices> sqlProviderServices;
    DropDownEditor dataSource;
    ValueBoxEditor<String> dbSchema;
    ValueBoxEditor<String> dbTable;
    ValueBoxEditor<String> dbSQL;
    public View view;
    private boolean isQuery;

    @Inject
    public SQLDataSetDefAttributesEditor(DropDownEditor dataSource, ValueBoxEditor<String> dbSchema, ValueBoxEditor<String> dbTable, ValueBoxEditor<String> dbSQL, Caller<SQLProviderServices> sqlProviderServices, View view) {
        this.dataSource = dataSource;
        this.dbSchema = dbSchema;
        this.dbTable = dbTable;
        this.dbSQL = dbSQL;
        this.sqlProviderServices = sqlProviderServices;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.dataSource.view, this.dbSchema.view, this.dbTable.view, this.dbSQL.view);
        this.dataSource.setSelectHint(DataSetEditorConstants.INSTANCE.sql_datasource_selectHint());
        ((SQLProviderServices)this.sqlProviderServices.call(list -> this.onSqlDataSourcesLoad((List<SQLDataSourceDef>)list))).getDataSourceDefs();
        this.dataSource.addHelpContent(DataSetEditorConstants.INSTANCE.sql_datasource(), DataSetEditorConstants.INSTANCE.sql_datasource_description(), Placement.RIGHT);
        this.dbSchema.addHelpContent(DataSetEditorConstants.INSTANCE.sql_schema(), DataSetEditorConstants.INSTANCE.sql_schema_description(), Placement.BOTTOM);
        this.dbTable.addHelpContent(DataSetEditorConstants.INSTANCE.sql_table(), DataSetEditorConstants.INSTANCE.sql_table_description(), Placement.BOTTOM);
        this.dbSQL.addHelpContent(DataSetEditorConstants.INSTANCE.sql_query(), DataSetEditorConstants.INSTANCE.sql_query_description(), Placement.BOTTOM);
        this.onSelectQuery();
    }

    private DropDownEditor.Entry toDropDownEntry(SQLDataSourceDef d) {
        return this.dataSource.newEntry(d.getName(), d.getDescription());
    }

    private void onSqlDataSourcesLoad(List<SQLDataSourceDef> list) {
        List entries = list.stream().map(this::toDropDownEntry).collect(Collectors.toList());
        this.dataSource.setEntries(entries);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public DropDownEditor dataSource() {
        return this.dataSource;
    }

    public ValueBoxEditor<String> dbSchema() {
        return this.dbSchema;
    }

    public ValueBoxEditor<String> dbTable() {
        return this.dbTable;
    }

    public ValueBoxEditor<String> dbSQL() {
        return this.dbSQL;
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(SQLDataSetDef value) {
        if (value != null && value.getDbTable() != null) {
            this.onSelectTable();
        } else {
            this.onSelectQuery();
        }
    }

    public void setDelegate(EditorDelegate<SQLDataSetDef> delegate) {
    }

    public boolean isUsingQuery() {
        return this.isQuery;
    }

    void onSelectTable() {
        this.view.table();
        this.isQuery = false;
    }

    void onSelectQuery() {
        this.view.query();
        this.isQuery = true;
    }

    public static interface View
    extends UberView<SQLDataSetDefAttributesEditor> {
        public void initWidgets(DropDownEditor.View var1, ValueBoxEditor.View var2, ValueBoxEditor.View var3, ValueBoxEditor.View var4);

        public void table();

        public void query();
    }
}

