/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.common.DataSetEditorPlugin;
import org.dashbuilder.client.widgets.dataset.event.DataSetDefCreationRequestEvent;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.list.HorizImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetDefProviderTypeEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefProviderTypeEditor {
    HorizImageListEditor<DataSetProviderType> provider;
    Event<DataSetDefCreationRequestEvent> createEvent;
    public View view;
    ManagedInstance<DataSetEditorPlugin> dataSetEditorPlugin;
    DataSetProviderType[] CORE_TYPES = new DataSetProviderType[]{DataSetProviderType.BEAN, DataSetProviderType.CSV, DataSetProviderType.SQL, DataSetProviderType.PROMETHEUS, DataSetProviderType.KAFKA};

    @Inject
    public DataSetDefProviderTypeEditor(HorizImageListEditor<DataSetProviderType> provider, Event<DataSetDefCreationRequestEvent> createEvent, View view, ManagedInstance<DataSetEditorPlugin> dataSetEditorPlugin) {
        this.provider = provider;
        this.createEvent = createEvent;
        this.view = view;
        this.dataSetEditorPlugin = dataSetEditorPlugin;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        Collection<ImageListEditor.Entry> entries = this.getDefaultEntries();
        this.provider.setEntries(entries);
        this.view.initWidgets((IsWidget)this.provider.view);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    void onItemClicked(@Observes ValueChangeEvent<DataSetProviderType> event) {
        PortablePreconditions.checkNotNull((String)"ValueChangeEvent<DataSetProviderType>", event);
        if (event.getContext().equals(this.provider)) {
            this.createEvent.fire((Object)new DataSetDefCreationRequestEvent(this, (DataSetProviderType)event.getValue()));
        }
    }

    public void showErrors(List<EditorError> errors) {
    }

    public HorizImageListEditor<DataSetProviderType> provider() {
        return this.provider;
    }

    protected Collection<ImageListEditor.Entry> getDefaultEntries() {
        DataSetProviderType[] providerTypes = this.CORE_TYPES;
        ArrayList<ImageListEditor.Entry> entries = new ArrayList<ImageListEditor.Entry>(providerTypes.length);
        for (DataSetProviderType type : providerTypes) {
            String title = this.getTypeSelectorTitle(type);
            String text = this.getTypeSelectorText(type);
            SafeUri uri = this.getTypeSelectorImageUri(type);
            ImageListEditor.Entry entry = this.provider.newEntry((Object)type, uri, new SafeHtmlBuilder().appendEscaped(title).toSafeHtml(), new SafeHtmlBuilder().appendEscaped(text).toSafeHtml());
            entries.add(entry);
        }
        if (!this.dataSetEditorPlugin.isUnsatisfied()) {
            for (DataSetEditorPlugin pluginEditor : this.dataSetEditorPlugin) {
                String title = pluginEditor.getTypeSelectorTitle();
                String text = pluginEditor.getTypeSelectorText();
                SafeUri uri = pluginEditor.getTypeSelectorImageUri();
                ImageListEditor.Entry entry = this.provider.newEntry((Object)pluginEditor.getProviderType(), uri, new SafeHtmlBuilder().appendEscaped(title).toSafeHtml(), new SafeHtmlBuilder().appendEscaped(text).toSafeHtml());
                entries.add(entry);
            }
        }
        return entries;
    }

    String getTypeSelectorTitle(DataSetProviderType type) {
        if (DataSetProviderType.BEAN.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.bean();
        }
        if (DataSetProviderType.CSV.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.csv();
        }
        if (DataSetProviderType.SQL.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.sql();
        }
        if (DataSetProviderType.PROMETHEUS.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.prometheus();
        }
        if (DataSetProviderType.KAFKA.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.kafka();
        }
        return null;
    }

    String getTypeSelectorText(DataSetProviderType type) {
        if (DataSetProviderType.BEAN.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.bean_description();
        }
        if (DataSetProviderType.CSV.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.csv_description();
        }
        if (DataSetProviderType.SQL.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.sql_description();
        }
        if (DataSetProviderType.PROMETHEUS.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.prometheus_description();
        }
        if (DataSetProviderType.KAFKA.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.kafka_description();
        }
        return null;
    }

    SafeUri getTypeSelectorImageUri(DataSetProviderType type) {
        if (DataSetProviderType.BEAN.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().javaIcon160().getSafeUri();
        }
        if (DataSetProviderType.CSV.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().csvIcon160().getSafeUri();
        }
        if (DataSetProviderType.SQL.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().sqlIcon160().getSafeUri();
        }
        if (DataSetProviderType.PROMETHEUS.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().prometheusIcon160().getSafeUri();
        }
        if (DataSetProviderType.KAFKA.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().kafkaIcon160().getSafeUri();
        }
        return null;
    }

    public static interface View
    extends UberView<DataSetDefProviderTypeEditor> {
        public void initWidgets(IsWidget var1);
    }
}

