/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.google.client;

import com.googlecode.gwt.charts.client.ChartLoader;
import com.googlecode.gwt.charts.client.ChartPackage;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractRendererLibrary;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.google.client.GoogleAreaChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleAreaChartDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleBarChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleBarChartDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleBubbleChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleBubbleChartDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleDisplayer;
import org.dashbuilder.renderer.google.client.GoogleLineChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleLineChartDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleMapDisplayer;
import org.dashbuilder.renderer.google.client.GoogleMapDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleMeterChartDisplayer;
import org.dashbuilder.renderer.google.client.GoogleMeterChartDisplayerView;
import org.dashbuilder.renderer.google.client.GooglePieChartDisplayer;
import org.dashbuilder.renderer.google.client.GooglePieChartDisplayerView;
import org.dashbuilder.renderer.google.client.GoogleTableDisplayer;
import org.dashbuilder.renderer.google.client.GoogleTableDisplayerView;

@ApplicationScoped
public class GoogleRenderer
extends AbstractRendererLibrary {
    public static final String UUID = "gwtcharts";
    private static Map<DisplayerType, ChartPackage> _packageTypes = new HashMap<DisplayerType, ChartPackage>();
    private List<DisplayerType> _supportedTypes = Arrays.asList(DisplayerType.BARCHART, DisplayerType.PIECHART, DisplayerType.AREACHART, DisplayerType.LINECHART, DisplayerType.BUBBLECHART, DisplayerType.METERCHART, DisplayerType.TABLE, DisplayerType.MAP);

    public String getUUID() {
        return UUID;
    }

    public String getName() {
        return "GWT Charts";
    }

    public boolean isDefault(DisplayerType type) {
        return DisplayerType.BARCHART.equals((Object)type) || DisplayerType.PIECHART.equals((Object)type) || DisplayerType.AREACHART.equals((Object)type) || DisplayerType.LINECHART.equals((Object)type) || DisplayerType.BUBBLECHART.equals((Object)type) || DisplayerType.METERCHART.equals((Object)type) || DisplayerType.MAP.equals((Object)type);
    }

    public List<DisplayerType> getSupportedTypes() {
        return this._supportedTypes;
    }

    public List<DisplayerSubType> getSupportedSubtypes(DisplayerType displayerType) {
        switch (displayerType) {
            case BARCHART: {
                return Arrays.asList(DisplayerSubType.BAR, DisplayerSubType.BAR_STACKED, DisplayerSubType.COLUMN, DisplayerSubType.COLUMN_STACKED);
            }
            case PIECHART: {
                return Arrays.asList(DisplayerSubType.PIE, DisplayerSubType.PIE_3D, DisplayerSubType.DONUT);
            }
            case AREACHART: {
                return Arrays.asList(DisplayerSubType.AREA, DisplayerSubType.AREA_STACKED);
            }
            case LINECHART: {
                return Arrays.asList(DisplayerSubType.LINE, DisplayerSubType.SMOOTH);
            }
            case MAP: {
                return Arrays.asList(DisplayerSubType.MAP_REGIONS, DisplayerSubType.MAP_MARKERS);
            }
        }
        return Arrays.asList(new DisplayerSubType[0]);
    }

    public Displayer lookupDisplayer(DisplayerSettings displayerSettings) {
        DisplayerType displayerType = displayerSettings.getType();
        if (DisplayerType.BARCHART.equals((Object)displayerType)) {
            GoogleBarChartDisplayer displayer = new GoogleBarChartDisplayer();
            ((GoogleBarChartDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        if (DisplayerType.PIECHART.equals((Object)displayerType)) {
            GooglePieChartDisplayer displayer = new GooglePieChartDisplayer();
            ((GooglePieChartDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        if (DisplayerType.AREACHART.equals((Object)displayerType)) {
            GoogleAreaChartDisplayer displayer = new GoogleAreaChartDisplayer();
            ((GoogleAreaChartDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        if (DisplayerType.LINECHART.equals((Object)displayerType)) {
            GoogleLineChartDisplayer displayer = new GoogleLineChartDisplayer();
            ((GoogleLineChartDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        if (DisplayerType.BUBBLECHART.equals((Object)displayerType)) {
            GoogleBubbleChartDisplayer displayer = new GoogleBubbleChartDisplayer();
            ((GoogleBubbleChartDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        if (DisplayerType.METERCHART.equals((Object)displayerType)) {
            GoogleMeterChartDisplayer displayer = new GoogleMeterChartDisplayer();
            ((GoogleMeterChartDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        if (DisplayerType.TABLE.equals((Object)displayerType)) {
            GoogleTableDisplayer displayer = new GoogleTableDisplayer();
            ((GoogleTableDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        if (DisplayerType.MAP.equals((Object)displayerType)) {
            GoogleMapDisplayer displayer = new GoogleMapDisplayer();
            ((GoogleMapDisplayerView)displayer.getView()).setRenderer(this);
            return displayer;
        }
        return null;
    }

    public void draw(final List<Displayer> displayerList) {
        EnumSet<ChartPackage> packageList = EnumSet.noneOf(ChartPackage.class);
        for (Displayer displayer : displayerList) {
            try {
                GoogleDisplayer googleDisplayer = (GoogleDisplayer)displayer;
                packageList.add(_packageTypes.get(googleDisplayer.getDisplayerSettings().getType()));
            }
            catch (ClassCastException googleDisplayer) {}
        }
        ChartPackage[] packageArray = new ChartPackage[packageList.size()];
        int i = 0;
        for (ChartPackage pkg : packageList) {
            packageArray[i++] = pkg;
        }
        ChartLoader chartLoader = new ChartLoader(packageArray);
        chartLoader.loadApi(new Runnable(){

            @Override
            public void run() {
                for (Displayer displayer : displayerList) {
                    try {
                        GoogleDisplayer googleDisplayer = (GoogleDisplayer)displayer;
                        googleDisplayer.ready();
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        });
    }

    static {
        _packageTypes.put(DisplayerType.BARCHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.PIECHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.AREACHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.LINECHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.BUBBLECHART, ChartPackage.CORECHART);
        _packageTypes.put(DisplayerType.METERCHART, ChartPackage.GAUGE);
        _packageTypes.put(DisplayerType.TABLE, ChartPackage.TABLE);
        _packageTypes.put(DisplayerType.MAP, ChartPackage.GEOCHART);
    }
}

