/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.json;

import java.util.ArrayList;
import org.dashbuilder.json.JsonArrayContext;
import org.dashbuilder.json.JsonBoolean;
import org.dashbuilder.json.JsonContext;
import org.dashbuilder.json.JsonFactory;
import org.dashbuilder.json.JsonNumber;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonType;
import org.dashbuilder.json.JsonUtil;
import org.dashbuilder.json.JsonValue;
import org.dashbuilder.json.JsonVisitor;

public class JsonArray
implements JsonValue {
    private ArrayList<JsonValue> arrayValues = new ArrayList();
    private JsonFactory factory;

    public JsonArray(JsonFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean isEmpty() {
        return this.arrayValues == null || this.arrayValues.isEmpty();
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public double asNumber() {
        switch (this.length()) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return this.get(0).asNumber();
            }
        }
        return Double.NaN;
    }

    @Override
    public String asString() {
        StringBuilder toReturn = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                toReturn.append(", ");
            }
            toReturn.append(this.get(i).asString());
        }
        return toReturn.toString();
    }

    public JsonValue get(int index) {
        return this.arrayValues.get(index);
    }

    public JsonArray getArray(int index) {
        return (JsonArray)this.get(index);
    }

    public boolean getBoolean(int index) {
        return ((JsonBoolean)this.get(index)).getBoolean();
    }

    public double getNumber(int index) {
        return ((JsonNumber)this.get(index)).getNumber();
    }

    public JsonObject getObject(int index) {
        return (JsonObject)this.get(index);
    }

    public String getString(int index) {
        JsonValue val = this.get(index);
        return val == null ? null : val.asString();
    }

    @Override
    public JsonType getType() {
        return JsonType.ARRAY;
    }

    public int length() {
        return this.arrayValues.size();
    }

    public void remove(int index) {
        this.arrayValues.remove(index);
    }

    public void set(int index, JsonValue value) {
        if (value == null) {
            value = this.factory.createNull();
        }
        if (index == this.arrayValues.size()) {
            this.arrayValues.add(index, value);
        } else {
            this.arrayValues.set(index, value);
        }
    }

    public void set(int index, String string) {
        this.set(index, this.factory.create(string));
    }

    public void set(int index, double number) {
        this.set(index, this.factory.create(number));
    }

    public void set(int index, boolean bool) {
        this.set(index, this.factory.create(bool));
    }

    @Override
    public String toJson() {
        return JsonUtil.stringify(this);
    }

    @Override
    public void traverse(JsonVisitor visitor, JsonContext ctx) {
        if (visitor.visit(this, ctx)) {
            JsonArrayContext arrayCtx = new JsonArrayContext(this);
            for (int i = 0; i < this.length(); ++i) {
                arrayCtx.setCurrentIndex(i);
                if (!visitor.visitIndex(arrayCtx.getCurrentIndex(), arrayCtx)) continue;
                visitor.accept(this.get(i), arrayCtx);
                arrayCtx.setFirst(false);
            }
        }
        visitor.endVisit(this, ctx);
    }
}

