/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import org.czeal.rfc3986.URIReference;
import org.czeal.rfc3986.Utils;

class URIReferenceResolver {
    URIReferenceResolver() {
    }

    private static String mergePath(String uriRefPath, String basePath, boolean hasAuthority) {
        if (hasAuthority && basePath.isEmpty()) {
            return "/".concat(uriRefPath);
        }
        return Utils.dropLastSegment(basePath, false).concat(uriRefPath);
    }

    URIReference resolve(URIReference uriRef, URIReference baseUriRef) {
        this.validate(uriRef, baseUriRef);
        URIReference.ProcessResult res = new URIReference.ProcessResult();
        res.charset = uriRef.getCharset();
        res.relativeReference = false;
        this.process(res, uriRef, baseUriRef);
        return res.toURIReference();
    }

    private void validate(URIReference uriRef, URIReference baseUriRef) {
        if (uriRef == null) {
            throw Utils.newNPE("The URI reference to be resolved must not be null.", new Object[0]);
        }
        if (baseUriRef == null) {
            throw Utils.newNPE("The base URI reference must not be null.", new Object[0]);
        }
        if (uriRef.getCharset() != baseUriRef.getCharset()) {
            throw Utils.newIAE("The charset of the target URI reference doesn't match the charset of the base URI.", new Object[0]);
        }
        if (baseUriRef.getScheme() == null) {
            throw Utils.newISE("The base URI must have a scheme.", new Object[0]);
        }
        if (baseUriRef.getFragment() != null) {
            throw Utils.newISE("The base URI must not have a fragment.", new Object[0]);
        }
    }

    private void process(URIReference.ProcessResult res, URIReference uriRef, URIReference baseUriRef) {
        if (uriRef.getScheme() != null) {
            this.processOnNonNullScheme(res, uriRef);
        } else {
            this.processOnNullScheme(res, uriRef, baseUriRef);
        }
        res.fragment = uriRef.getFragment();
    }

    private void processOnNonNullScheme(URIReference.ProcessResult res, URIReference uriRef) {
        res.scheme = uriRef.getScheme();
        res.authority = uriRef.getAuthority();
        res.path = Utils.removeDotSegments(uriRef.getPath());
        res.query = uriRef.getQuery();
    }

    private void processOnNullScheme(URIReference.ProcessResult res, URIReference uriRef, URIReference baseUriRef) {
        if (uriRef.getAuthority() != null) {
            this.processOnNonNullAuthority(res, uriRef, baseUriRef);
        } else {
            this.processOnNullAuthority(res, uriRef, baseUriRef);
        }
        res.scheme = baseUriRef.getScheme();
    }

    private void processOnNonNullAuthority(URIReference.ProcessResult res, URIReference uriRef, URIReference baseUriRef) {
        res.authority = uriRef.getAuthority();
        res.path = Utils.removeDotSegments(uriRef.getPath());
        res.query = uriRef.getQuery();
    }

    private void processOnNullAuthority(URIReference.ProcessResult res, URIReference uriRef, URIReference baseUriRef) {
        if (!uriRef.getPath().isEmpty()) {
            this.processOnNonNullPath(res, uriRef, baseUriRef);
        } else {
            this.processOnNullPath(res, uriRef, baseUriRef);
        }
        res.authority = baseUriRef.getAuthority();
    }

    private void processOnNonNullPath(URIReference.ProcessResult res, URIReference uriRef, URIReference baseUriRef) {
        res.path = uriRef.getPath().startsWith("/") ? Utils.removeDotSegments(uriRef.getPath()) : Utils.removeDotSegments(URIReferenceResolver.mergePath(uriRef.getPath(), baseUriRef.getPath(), baseUriRef.hasAuthority()));
        res.query = uriRef.getQuery();
    }

    private void processOnNullPath(URIReference.ProcessResult res, URIReference uriRef, URIReference baseUriRef) {
        res.path = baseUriRef.getPath();
        res.query = uriRef.getQuery() != null ? uriRef.getQuery() : baseUriRef.getQuery();
    }
}

