/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.czeal.rfc3986.QueryParam;
import org.czeal.rfc3986.Utils;

class QueryParams {
    private List<QueryParam> params;

    static QueryParams parse(String queryParams) {
        if (queryParams == null) {
            return null;
        }
        List<QueryParam> params = Arrays.stream(queryParams.split("&", -1)).map(e -> QueryParam.parse(e)).collect(Collectors.toList());
        return new QueryParams(params);
    }

    QueryParams() {
        this(new ArrayList<QueryParam>(0));
    }

    QueryParams(List<QueryParam> params) {
        if (params == null) {
            throw Utils.newNPE("The params must not be null.", new Object[0]);
        }
        this.params = params;
    }

    QueryParams add(String key, String value) {
        this.params.add(new QueryParam(key, value));
        return this;
    }

    QueryParams replace(String key, String value) {
        this.params = this.params.stream().map(e -> e.getKey().equals(key) ? new QueryParam(key, value) : e).collect(Collectors.toList());
        return this;
    }

    QueryParams remove(String key) {
        this.params = this.params.stream().filter(e -> !e.getKey().equals(key)).collect(Collectors.toList());
        return this;
    }

    boolean isEmpty() {
        return this.params.isEmpty();
    }

    public String toString() {
        return this.params.stream().map(QueryParam::toString).collect(Collectors.joining("&"));
    }
}

