/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import org.czeal.rfc3986.Utils;

class QueryParam {
    private final String key;
    private final String value;

    static QueryParam parse(String queryParams) {
        if (queryParams == null) {
            throw Utils.newNPE("The input string must not be null.", new Object[0]);
        }
        String[] kv = queryParams.split("=", 2);
        String k = kv[0];
        String v = kv.length > 1 ? kv[1] : null;
        return new QueryParam(k, v);
    }

    QueryParam(String key, String value) {
        if (key == null) {
            throw Utils.newNPE("The key must not be null.", new Object[0]);
        }
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return this.key;
        }
        return String.join((CharSequence)"=", this.key, this.value);
    }
}

