/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Set;
import org.czeal.rfc3986.Utils;

class PercentEncoder {
    static String encode(String input, Charset charset) {
        return PercentEncoder.encode(input, charset, null);
    }

    static String encode(String input, Charset charset, Set<Character> preservedChars) {
        return new PercentEncoder().process(input, charset, preservedChars);
    }

    private PercentEncoder() {
    }

    private String process(String input, Charset charset, Set<Character> preservedChars) {
        this.validate(input, charset);
        StringBuilder outputBuilder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (this.isPreserved(preservedChars, c)) {
                outputBuilder.append(c);
                continue;
            }
            outputBuilder.append(this.encode(charset, c));
        }
        return outputBuilder.toString();
    }

    private void validate(String input, Charset charset) {
        if (input == null) {
            throw Utils.newNPE("A input must not be null.", new Object[0]);
        }
        if (charset == null) {
            throw Utils.newNPE("A charset must not be null.", new Object[0]);
        }
    }

    private boolean isPreserved(Set<Character> preservedChars, char c) {
        return preservedChars != null ? preservedChars.contains(Character.valueOf(c)) : Utils.isUnreserved(c);
    }

    private char[] encode(Charset charset, char c) {
        byte[] bytes = this.toBytes(charset, c);
        char[] chars = new char[3 * bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[3 * i] = 37;
            chars[3 * i + 1] = Utils.toHexDigit((bytes[i] & 0xF0) >> 4);
            chars[3 * i + 2] = Utils.toHexDigit(bytes[i] & 0xF);
        }
        return chars;
    }

    private byte[] toBytes(Charset charset, char c) {
        try {
            return charset.newEncoder().encode(CharBuffer.wrap(String.valueOf(c))).array();
        }
        catch (CharacterCodingException e) {
            throw Utils.newIAE("Failed to encode the character \"" + c + "\".", new Object[0]);
        }
    }
}

