/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.czeal.rfc3986.PercentEncodedStringProcessor;
import org.czeal.rfc3986.PercentEncoder;
import org.czeal.rfc3986.Utils;

abstract class PercentEncodedStringNormalizer
extends PercentEncodedStringProcessor {
    PercentEncodedStringNormalizer() {
    }

    @Override
    protected void onDecoded(Charset charset, StringBuilder outputBuilder, CharBuffer buffer) {
        String normalized = buffer.toString();
        if (this.toLowerCase()) {
            normalized = normalized.toLowerCase();
        }
        normalized = PercentEncoder.encode(normalized, charset);
        outputBuilder.append(normalized);
    }

    @Override
    protected void onNonPercent(String input, StringBuilder outputBuilder, char c, int index) {
        char normalized = this.toLowerCase() ? Character.toLowerCase(c) : c;
        outputBuilder.append(normalized);
    }

    @Override
    protected IllegalArgumentException onMalformedPercentEncodedValue(String input, int index) {
        throw Utils.newISE("onMalformedPercentEncodedValue() is not supposed to be called.", new Object[0]);
    }

    @Override
    protected IllegalArgumentException onInvalidHexDigit(String input, char hexDigit, int index) {
        throw Utils.newISE("onInvalidHexDigit() is not supposed to be called.", new Object[0]);
    }

    @Override
    protected IllegalArgumentException onDecodeFailed(String input, PercentEncodedStringProcessor.Info info) {
        throw Utils.newISE("onDecodeFailed(input) is not supposed to be called.", new Object[0]);
    }

    protected abstract boolean toLowerCase();
}

