/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.charset.Charset;
import org.czeal.rfc3986.SegmentNzNcValidator;
import org.czeal.rfc3986.SegmentNzValidator;
import org.czeal.rfc3986.SegmentValidator;
import org.czeal.rfc3986.Utils;

class PathValidator {
    PathValidator() {
    }

    void validate(String path, Charset charset, boolean relativeReference, boolean hasAuthority) {
        if (hasAuthority) {
            this.validatePathAbempty(path, charset);
            return;
        }
        try {
            this.validatePathEmpty(path);
            return;
        }
        catch (Throwable throwable) {
            try {
                this.validatePathAbsolute(path, charset);
                return;
            }
            catch (Throwable throwable2) {
                if (relativeReference) {
                    this.validatePathNoscheme(path, charset);
                } else {
                    this.validatePathRootless(path, charset);
                }
                return;
            }
        }
    }

    private void validatePathAbempty(String path, Charset charset) {
        if (path == null || path.isEmpty()) {
            return;
        }
        this.ensurePathStartsWithSlash(path);
        if (path.length() == 1) {
            return;
        }
        String[] segments = path.substring(1).split("/", -1);
        for (int i = 0; i < segments.length; ++i) {
            new SegmentValidator().validate(segments[i], charset);
        }
    }

    private void validatePathAbsolute(String path, Charset charset) {
        this.ensurePathNotEmpty(path);
        this.ensurePathStartsWithSlash(path);
        if (path.length() == 1) {
            return;
        }
        String[] segments = path.substring(1).split("/", -1);
        new SegmentNzValidator().validate(segments[0], charset);
        for (int i = 1; i < segments.length; ++i) {
            new SegmentValidator().validate(segments[i], charset);
        }
    }

    private void validatePathNoscheme(String path, Charset charset) {
        this.ensurePathNotEmpty(path);
        String[] segments = path.split("/", -1);
        new SegmentNzNcValidator().validate(segments[0], charset);
        for (int i = 1; i < segments.length; ++i) {
            new SegmentValidator().validate(segments[i], charset);
        }
    }

    private void validatePathRootless(String path, Charset charset) {
        this.ensurePathNotEmpty(path);
        String[] segments = path.split("/", -1);
        new SegmentNzValidator().validate(segments[0], charset);
        for (int i = 1; i < segments.length; ++i) {
            new SegmentValidator().validate(segments[i], charset);
        }
    }

    private void validatePathEmpty(String path) {
        if (!path.isEmpty()) {
            throw Utils.newIAE("The path must be empty", new Object[0]);
        }
    }

    private void ensurePathNotEmpty(String path) {
        if (path == null || path.isEmpty()) {
            throw Utils.newIAE("The path must not be empty.", new Object[0]);
        }
    }

    private void ensurePathStartsWithSlash(String path) {
        if (!path.startsWith("/")) {
            throw Utils.newIAE("The path must start with a slash.", new Object[0]);
        }
    }
}

