/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.czeal.rfc3986.Utils;

class PathSegments {
    private final List<String> segments;

    static PathSegments parse(String pathSegments) {
        if (pathSegments == null) {
            return null;
        }
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(pathSegments.split("/", -1)));
        return new PathSegments(segments);
    }

    public PathSegments() {
        this(new ArrayList<String>(0));
    }

    public PathSegments(List<String> segments) {
        if (segments == null) {
            throw Utils.newNPE("params must not be null.", new Object[0]);
        }
        this.segments = segments;
    }

    public PathSegments add(String ... segments) {
        if (segments == null) {
            throw Utils.newNPE("The segments must not be null.", new Object[0]);
        }
        for (String s : segments) {
            if (s != null) continue;
            throw Utils.newNPE("A segment must not be null.", new Object[0]);
        }
        Collections.addAll(this.segments, segments);
        return this;
    }

    public String toString() {
        if (this.segments == null) {
            return "";
        }
        return String.join((CharSequence)"/", this.segments);
    }
}

