/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import org.czeal.rfc3986.Utils;

class Ipv4AddressValidator {
    Ipv4AddressValidator() {
    }

    void validate(String ipv4Address) {
        String[] decOctets = ipv4Address.split("\\.", -1);
        if (decOctets.length != 4) {
            throw Utils.newIAE("The host value \"%s\" is invalid as an IPv4 address because the number of octets contained in the host is invalid.", ipv4Address);
        }
        for (int i = 0; i < 4; ++i) {
            this.validateDecOctet(decOctets[i], ipv4Address);
        }
    }

    private void validateDecOctet(String decOctet, String value) {
        if (decOctet.isEmpty()) {
            throw Utils.newIAE("The host value \"%s\" is invalid as an IPv4 address because it contain an empty octet.", value);
        }
        int length = decOctet.length();
        if (length == 1) {
            this.validateSingleDigitDecOctet(decOctet, value);
            return;
        }
        if (length == 2) {
            this.validateTwoDigitDecOctet(decOctet, value);
            return;
        }
        if (length == 3) {
            this.validateThreeDigitDecOctet(decOctet, value);
            return;
        }
        throw Utils.newIAE("The host value \"%s\" is invalid as an IPv4 address because the octet \"%s\" has more than 3 characters.", value, decOctet);
    }

    private void validateSingleDigitDecOctet(String decOctet, String rawHost) {
        this.ensureDecOctetDigit(rawHost, decOctet, 0);
    }

    private void validateTwoDigitDecOctet(String decOctet, String rawHost) {
        this.ensureDecOctetDigit(rawHost, decOctet, 0);
        this.ensureDecOctetDigit(rawHost, decOctet, 1);
    }

    private void validateThreeDigitDecOctet(String decOctet, String rawHost) {
        char firstDigit = decOctet.charAt(0);
        if (firstDigit == '1') {
            this.validateThreeDigitDecOctetStartingWithOne(decOctet, rawHost);
            return;
        }
        if (firstDigit == '2') {
            this.validateThreeDigitDecOctetStartingWithTwo(decOctet, rawHost);
            return;
        }
        throw this.invalidDecOctet(rawHost, decOctet, firstDigit, 0);
    }

    private void validateThreeDigitDecOctetStartingWithOne(String decOctet, String rawHost) {
        this.ensureDecOctetDigit(rawHost, decOctet, 1);
        this.ensureDecOctetDigit(rawHost, decOctet, 2);
    }

    private void validateThreeDigitDecOctetStartingWithTwo(String decOctet, String rawHost) {
        char secondDigit = decOctet.charAt(1);
        if (Utils.isInRange(secondDigit, '0', '4')) {
            this.ensureDecOctetDigit(rawHost, decOctet, 2);
            return;
        }
        if (secondDigit == '5') {
            this.ensureDecOctetInRangeFromZeroToFive(rawHost, decOctet, 2);
            return;
        }
        throw this.invalidDecOctet(rawHost, decOctet, secondDigit, 1);
    }

    private void ensureDecOctetDigit(String rawHost, String decOctet, int index) {
        char digit = decOctet.charAt(index);
        if (!Utils.isDigit(digit)) {
            throw this.invalidDecOctet(rawHost, decOctet, digit, index);
        }
    }

    private void ensureDecOctetInRangeFromZeroToFive(String rawHost, String decOctet, int index) {
        char digit = decOctet.charAt(index);
        if (!Utils.isInRange(digit, '0', '5')) {
            throw this.invalidDecOctet(rawHost, decOctet, digit, index);
        }
    }

    private IllegalArgumentException invalidDecOctet(String rawHost, String decOctet, char digit, int index) {
        return Utils.newIAE("The host value \"%s\" is invalid as an IPv4 address because the octet \"%s\" has an invalid character \"%s\" at the index %d.", rawHost, decOctet, Character.valueOf(digit), index);
    }
}

