/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.czeal.rfc3986.Authority;
import org.czeal.rfc3986.Host;
import org.czeal.rfc3986.PortValidator;
import org.czeal.rfc3986.UserinfoValidator;
import org.czeal.rfc3986.Utils;

class AuthorityParser {
    private static final Pattern PATTERN_AUTHORITY = Pattern.compile("((?<userinfo>[^@]*)@)?(?<host>(\\[[^]]*\\])|[^:]*)?(:(?<port>.*))?");

    AuthorityParser() {
    }

    Authority parse(String authority, Charset charset) {
        if (authority == null) {
            return null;
        }
        ParseResult res = new ParseResult();
        this.processAuthority(res, authority);
        this.processUserinfo(res, charset);
        this.processHost(res, charset);
        this.processPort(res);
        return res.toAuthority();
    }

    private void processAuthority(ParseResult res, String authority) {
        Matcher matcher = PATTERN_AUTHORITY.matcher(authority);
        if (!matcher.matches()) {
            throw Utils.newIAE("The input \"%s\" is invalid as an authority.", authority);
        }
        res.matcher = matcher;
    }

    private void processUserinfo(ParseResult res, Charset charset) {
        String rawUserinfo = res.matcher.group("userinfo");
        new UserinfoValidator().validate(rawUserinfo, charset);
        res.userinfo = rawUserinfo;
    }

    private void processHost(ParseResult res, Charset charset) {
        String rawHost = res.matcher.group("host");
        res.host = Host.parse(rawHost, charset);
    }

    private void processPort(ParseResult res) {
        String rawPort = res.matcher.group("port");
        new PortValidator().validate(rawPort);
        res.port = this.parsePort(rawPort);
    }

    private int parsePort(String rawPort) {
        if (rawPort == null || rawPort.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(rawPort);
        }
        catch (NumberFormatException e) {
            throw Utils.newIAE("The port value \"%s\" is invalid as a number.", rawPort);
        }
    }

    private static class ParseResult
    extends Authority.ProcessResult {
        Matcher matcher;

        private ParseResult() {
        }
    }
}

