/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.charset.Charset;
import org.czeal.rfc3986.Authority;
import org.czeal.rfc3986.HostNormalizer;
import org.czeal.rfc3986.PortNormalizer;
import org.czeal.rfc3986.UserinfoNormalizer;

class AuthorityNormalizer {
    AuthorityNormalizer() {
    }

    Authority normalize(Authority authority, Charset charset, String normalizedScheme) {
        if (authority == null) {
            return null;
        }
        Authority.ProcessResult res = new Authority.ProcessResult();
        this.processUserinfo(res, authority, charset);
        this.processHost(res, authority, charset);
        this.processPort(res, authority, normalizedScheme);
        return res.toAuthority();
    }

    private void processUserinfo(Authority.ProcessResult res, Authority authority, Charset charset) {
        res.userinfo = new UserinfoNormalizer().normalize(authority.getUserinfo(), charset);
    }

    private void processHost(Authority.ProcessResult res, Authority authority, Charset charset) {
        res.host = new HostNormalizer().normalize(authority.getHost(), charset);
    }

    private void processPort(Authority.ProcessResult res, Authority authority, String normalizedScheme) {
        res.port = new PortNormalizer().normalize(authority.getPort(), normalizedScheme);
    }
}

