/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.nio.charset.Charset;
import org.czeal.rfc3986.Authority;
import org.czeal.rfc3986.Host;
import org.czeal.rfc3986.PortValidator;
import org.czeal.rfc3986.UserinfoValidator;

class AuthorityBuilder {
    private Charset charset;
    private String userinfo;
    private String host;
    private int port = -1;

    AuthorityBuilder() {
    }

    AuthorityBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    AuthorityBuilder setUserinfo(String userinfo) {
        this.userinfo = userinfo;
        return this;
    }

    AuthorityBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    AuthorityBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    Authority build() {
        Authority.ProcessResult res = new Authority.ProcessResult();
        this.processUserinfo(res);
        this.processHost(res);
        this.processPort(res);
        return res.toAuthority();
    }

    private void processUserinfo(Authority.ProcessResult res) {
        new UserinfoValidator().validate(this.userinfo, this.charset);
        res.userinfo = this.userinfo;
    }

    private void processHost(Authority.ProcessResult res) {
        res.host = Host.parse(this.host, this.charset);
    }

    private void processPort(Authority.ProcessResult res) {
        new PortValidator().validate(this.port);
        res.port = this.port;
    }
}

