/*
 * Decompiled with CFR 0.152.
 */
package org.czeal.rfc3986;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.czeal.rfc3986.AuthorityParser;
import org.czeal.rfc3986.Host;

public class Authority
implements Serializable,
Comparable<Authority> {
    private static final long serialVersionUID = 1L;
    private final String userinfo;
    private final Host host;
    private final int port;

    static Authority parse(String authority) {
        return Authority.parse(authority, StandardCharsets.UTF_8);
    }

    static Authority parse(String authority, Charset charset) {
        return new AuthorityParser().parse(authority, charset);
    }

    private Authority(ProcessResult res) {
        this.userinfo = res.userinfo;
        this.host = res.host;
        this.port = res.port;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public Host getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.userinfo != null) {
            sb.append(this.userinfo).append("@");
        }
        if (this.host != null && this.host.getValue() != null) {
            sb.append(this.host.getValue());
        }
        if (this.port != -1) {
            sb.append(":").append(this.port);
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Authority)) {
            return false;
        }
        return this.compareTo((Authority)other) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.userinfo, this.host, this.port);
    }

    @Override
    public int compareTo(Authority other) {
        return this.hashCode() - other.hashCode();
    }

    static class ProcessResult {
        String userinfo;
        Host host;
        int port = -1;

        ProcessResult() {
        }

        Authority toAuthority() {
            return new Authority(this);
        }
    }
}

