/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.cyclonedx.maven.BaseCycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makePackageBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxPackageMojo
extends BaseCycloneDxMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;

    protected boolean shouldInclude(MavenProject mavenProject) {
        return Arrays.asList("war", "ear").contains(mavenProject.getPackaging());
    }

    @Override
    protected boolean analyze(Set<Component> components, Set<Dependency> dependencies) throws MojoExecutionException {
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        for (MavenProject mavenProject : this.reactorProjects) {
            if (!this.shouldInclude(mavenProject)) continue;
            this.getLog().info((CharSequence)("Analyzing " + mavenProject.getArtifactId()));
            for (Artifact artifact : mavenProject.getArtifacts()) {
                if (!this.shouldInclude(artifact)) continue;
                Component component = this.convert(artifact);
                boolean found = false;
                for (String s : componentRefs) {
                    if (s == null || !s.equals(component.getBomRef())) continue;
                    found = true;
                }
                if (found) continue;
                componentRefs.add(component.getBomRef());
                components.add(component);
            }
            if (!(this.schemaVersion().getVersion() >= 1.2)) continue;
            dependencies.addAll(this.buildDependencyGraph(componentRefs, mavenProject));
        }
        return true;
    }
}

