/*
 * This file is part of CycloneDX Core (Java).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) OWASP Foundation. All Rights Reserved.
 */
package org.cyclonedx;

public class CycloneDxMediaType {

    private CycloneDxMediaType() { }

    /**
     * Official CycloneDX XML media type assigned by IANA.
     *
     * https://www.iana.org/assignments/media-types/application/vnd.cyclonedx+xml
     */
    public static final String APPLICATION_CYCLONEDX_XML = "application/vnd.cyclonedx+xml";

    /**
     * Official CycloneDX JSON media type assigned by IANA.
     *
     * https://www.iana.org/assignments/media-types/application/vnd.cyclonedx+json
     */
    public static final String APPLICATION_CYCLONEDX_JSON = "application/vnd.cyclonedx+json";

}
