/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import org.cyclonedx.model.LifecycleChoice;
import org.cyclonedx.model.Lifecycles;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public class LifecycleDeserializer
extends JsonDeserializer<Lifecycles> {
    public Lifecycles deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayList<LifecycleChoice> choices = new ArrayList<LifecycleChoice>();
        if (node.has("lifecycle")) {
            node = node.get("lifecycle");
        }
        if (node != null) {
            ArrayNode nodes = DeserializerUtils.getArrayNode(node, null);
            for (JsonNode choiceNode : nodes) {
                LifecycleChoice choice = this.createLifecycleChoice(choiceNode);
                if (choice == null) continue;
                choices.add(choice);
            }
        }
        Lifecycles lifecycles = new Lifecycles();
        lifecycles.setLifecycleChoice(choices);
        return lifecycles;
    }

    private LifecycleChoice createLifecycleChoice(JsonNode choiceNode) {
        LifecycleChoice choice = new LifecycleChoice();
        JsonNode phaseNode = choiceNode.get("phase");
        if (phaseNode != null) {
            LifecycleChoice.Phase phase = LifecycleChoice.Phase.fromString(phaseNode.asText());
            choice.setPhase(phase);
            return choice;
        }
        JsonNode nameNode = choiceNode.get("name");
        JsonNode descriptionNode = choiceNode.get("description");
        if (nameNode != null && descriptionNode != null) {
            choice.setName(nameNode.asText());
            choice.setDescription(descriptionNode.asText());
            return choice;
        }
        return null;
    }
}

