/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.BomReference;
import org.cyclonedx.model.component.evidence.Identity;
import org.cyclonedx.model.component.evidence.Method;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public class IdentityDeserializer
extends JsonDeserializer<List<Identity>> {
    private final ObjectMapper mapper = new ObjectMapper();

    public List<Identity> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return this.parseIdentities(node);
    }

    private List<Identity> parseIdentities(JsonNode node) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (node.has("identity")) {
            node = node.get("identity");
        }
        if (node.isArray()) {
            for (JsonNode identityNode : node) {
                identities.add(this.parseSingleIdentity(identityNode));
            }
        } else {
            identities.add(this.parseSingleIdentity(node));
        }
        return identities;
    }

    private Identity parseSingleIdentity(JsonNode node) {
        Identity identity = new Identity();
        if (node.has("field")) {
            Identity.Field field = (Identity.Field)((Object)this.mapper.convertValue((Object)node.get("field"), Identity.Field.class));
            identity.setField(field);
        }
        if (node.has("confidence")) {
            identity.setConfidence(node.get("confidence").asDouble());
        }
        if (node.has("concludedValue")) {
            identity.setConcludedValue(node.get("concludedValue").asText());
        }
        if (node.has("methods")) {
            identity.setMethods(this.parseMethods(node.get("methods")));
        }
        if (node.has("tools")) {
            identity.setTools(this.parseTools(node.get("tools")));
        }
        return identity;
    }

    private List<Method> parseMethods(JsonNode methodsNode) {
        if (methodsNode.has("method")) {
            methodsNode = methodsNode.get("method");
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(methodsNode, this.mapper);
        for (JsonNode methodNode : nodes) {
            methods.add((Method)this.mapper.convertValue((Object)methodNode, Method.class));
        }
        return methods;
    }

    private List<BomReference> parseTools(JsonNode toolsNode) {
        if (toolsNode.has("tool")) {
            toolsNode = toolsNode.get("tool");
        }
        ArrayNode nodes = DeserializerUtils.getArrayNode(toolsNode, this.mapper);
        ArrayList<BomReference> tools = new ArrayList<BomReference>();
        for (JsonNode toolNode : nodes) {
            tools.add((BomReference)this.mapper.convertValue((Object)toolNode, BomReference.class));
        }
        return tools;
    }
}

