/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.deserializer.ToolInformationDeserializer;
import org.cyclonedx.util.deserializer.ToolsDeserializer;

public class ToolsJsonParser {
    private final ToolInformationDeserializer toolInformationDeserializer = new ToolInformationDeserializer();
    private final ToolsDeserializer toolsDeserializer = new ToolsDeserializer();
    private ToolInformation toolInformation;
    private List<Tool> tools;

    public ToolsJsonParser(JsonNode node, JsonParser parser, DeserializationContext context) throws IOException {
        this.parse(node, parser, context);
    }

    private void parse(JsonNode node, JsonParser parser, DeserializationContext context) throws IOException {
        if (node.has("tools")) {
            JsonNode toolsNode = node.get("tools");
            JsonParser toolsParser = toolsNode.traverse(parser.getCodec());
            toolsParser.nextToken();
            if (toolsNode.has("components") || toolsNode.has("services")) {
                this.toolInformation = this.toolInformationDeserializer.deserialize(toolsParser, context);
            } else {
                this.tools = this.toolsDeserializer.deserialize(toolsParser, context);
            }
        }
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public ToolInformation getToolInformation() {
        return this.toolInformation;
    }
}

