/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.packageurl.PackageURL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.Version;
import org.cyclonedx.model.Evidence;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.JsonOnly;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Pedigree;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.ReleaseNotes;
import org.cyclonedx.model.Signature;
import org.cyclonedx.model.Swid;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.model.component.ModelCard;
import org.cyclonedx.model.component.Tags;
import org.cyclonedx.model.component.crypto.CryptoProperties;
import org.cyclonedx.model.component.data.ComponentData;
import org.cyclonedx.util.deserializer.ComponentListDeserializer;
import org.cyclonedx.util.deserializer.ExternalReferencesDeserializer;
import org.cyclonedx.util.deserializer.HashesDeserializer;
import org.cyclonedx.util.deserializer.LicenseDeserializer;
import org.cyclonedx.util.deserializer.PropertiesDeserializer;

@JacksonXmlRootElement(localName="component")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"type", "bom-ref", "supplier", "manufacturer", "authors", "author", "publisher", "group", "name", "version", "description", "scope", "hashes", "licenses", "copyright", "cpe", "purl", "omniborId", "swhid", "swid", "modified", "pedigree", "externalReferences", "properties", "components", "evidence", "releaseNotes", "modelCard", "data", "cryptoProperties", "signature", "provides"})
public class Component
extends ExtensibleElement {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    @VersionFilter(value=Version.VERSION_11)
    private String bomRef;
    @JacksonXmlProperty(isAttribute=true, localName="mime-type")
    @JsonProperty(value="mime-type")
    private String mimeType;
    @JacksonXmlProperty(isAttribute=true)
    private Type type;
    @VersionFilter(value=Version.VERSION_12)
    private OrganizationalEntity supplier;
    @Deprecated
    @VersionFilter(value=Version.VERSION_12)
    private String author;
    @VersionFilter(value=Version.VERSION_11)
    private String publisher;
    private String group;
    private String name;
    private String version;
    private String description;
    private Scope scope;
    private List<Hash> hashes;
    private LicenseChoice licenses;
    private String copyright;
    private String cpe;
    private String purl;
    @VersionFilter(value=Version.VERSION_16)
    private List<String> omniborId;
    @VersionFilter(value=Version.VERSION_16)
    private List<String> swhid;
    @VersionFilter(value=Version.VERSION_12)
    private Swid swid;
    private Boolean modified;
    @VersionFilter(value=Version.VERSION_11)
    private Pedigree pedigree;
    @VersionFilter(value=Version.VERSION_11)
    private List<ExternalReference> externalReferences;
    @VersionFilter(value=Version.VERSION_13)
    private List<Property> properties;
    private List<Component> components;
    @VersionFilter(value=Version.VERSION_13)
    private Evidence evidence;
    @VersionFilter(value=Version.VERSION_14)
    private ReleaseNotes releaseNotes;
    @VersionFilter(value=Version.VERSION_15)
    @JsonProperty(value="modelCard")
    private ModelCard modelCard;
    @VersionFilter(value=Version.VERSION_15)
    private List<ComponentData> data;
    @VersionFilter(value=Version.VERSION_16)
    @JsonProperty(value="cryptoProperties")
    private CryptoProperties cryptoProperties;
    @VersionFilter(value=Version.VERSION_16)
    @JsonProperty(value="provides")
    private List<String> provides;
    @VersionFilter(value=Version.VERSION_16)
    @JsonUnwrapped
    private Tags tags;
    @VersionFilter(value=Version.VERSION_16)
    @JsonProperty(value="authors")
    private List<OrganizationalContact> authors;
    @VersionFilter(value=Version.VERSION_16)
    @JsonProperty(value="manufacturer")
    private OrganizationalEntity manufacturer;
    @JsonOnly
    @VersionFilter(value=Version.VERSION_14)
    private Signature signature;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public OrganizationalEntity getSupplier() {
        return this.supplier;
    }

    public void setSupplier(OrganizationalEntity supplier) {
        this.supplier = supplier;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @JacksonXmlElementWrapper(localName="hashes")
    @JacksonXmlProperty(localName="hash")
    @JsonDeserialize(using=HashesDeserializer.class)
    public List<Hash> getHashes() {
        return this.hashes;
    }

    public void setHashes(List<Hash> hashes) {
        this.hashes = hashes;
    }

    public void addHash(Hash hash) {
        if (this.hashes == null) {
            this.hashes = new ArrayList<Hash>();
        }
        this.hashes.add(hash);
    }

    @JsonDeserialize(using=LicenseDeserializer.class)
    public LicenseChoice getLicenses() {
        return this.licenses;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public void setLicenses(LicenseChoice licenses) {
        this.licenses = licenses;
    }

    @Deprecated
    public LicenseChoice getLicenseChoice() {
        return this.getLicenses();
    }

    @Deprecated
    @JsonIgnore
    public void setLicenseChoice(LicenseChoice licenseChoice) {
        this.setLicenses(licenseChoice);
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getCpe() {
        return this.cpe;
    }

    public void setCpe(String cpe) {
        this.cpe = cpe;
    }

    public String getPurl() {
        return this.purl;
    }

    public void setPurl(String purl) {
        this.purl = purl;
    }

    public void setPurl(PackageURL purl) {
        this.purl = purl.canonicalize();
    }

    public Swid getSwid() {
        return this.swid;
    }

    public void setSwid(Swid swid) {
        this.swid = swid;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getModified() {
        return this.modified;
    }

    public Boolean isModified() {
        return this.modified;
    }

    public void setModified(Boolean modified) {
        this.modified = modified;
    }

    public Pedigree getPedigree() {
        return this.pedigree;
    }

    public void setPedigree(Pedigree pedigree) {
        this.pedigree = pedigree;
    }

    @JacksonXmlElementWrapper(localName="externalReferences")
    @JacksonXmlProperty(localName="reference")
    @JsonDeserialize(using=ExternalReferencesDeserializer.class)
    @VersionFilter(value=Version.VERSION_11)
    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void addExternalReference(ExternalReference externalReference) {
        if (this.externalReferences == null) {
            this.externalReferences = new ArrayList<ExternalReference>();
        }
        this.externalReferences.add(externalReference);
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    @JsonDeserialize(using=PropertiesDeserializer.class)
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
    }

    @JacksonXmlElementWrapper(localName="components")
    @JacksonXmlProperty(localName="component")
    @JsonDeserialize(using=ComponentListDeserializer.class)
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void addComponent(Component component) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(component);
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public void setEvidence(Evidence evidence) {
        this.evidence = evidence;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ReleaseNotes getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(ReleaseNotes releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public ModelCard getModelCard() {
        return this.modelCard;
    }

    public void setModelCard(ModelCard modelCard) {
        this.modelCard = modelCard;
    }

    @JsonProperty(value="data")
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="data")
    public List<ComponentData> getData() {
        return this.data;
    }

    public void setData(List<ComponentData> data) {
        this.data = data;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @VersionFilter(value=Version.VERSION_16)
    public List<String> getOmniborId() {
        return this.omniborId;
    }

    public void setOmniborId(List<String> omniborId) {
        this.omniborId = omniborId;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @VersionFilter(value=Version.VERSION_16)
    public List<String> getSwhid() {
        return this.swhid;
    }

    public void setSwhid(List<String> swhid) {
        this.swhid = swhid;
    }

    public CryptoProperties getCryptoProperties() {
        return this.cryptoProperties;
    }

    public void setCryptoProperties(CryptoProperties cryptoProperties) {
        this.cryptoProperties = cryptoProperties;
    }

    public List<String> getProvides() {
        return this.provides;
    }

    public void setProvides(List<String> provides) {
        this.provides = provides;
    }

    public Tags getTags() {
        return this.tags;
    }

    public void setTags(Tags tags) {
        this.tags = tags;
    }

    public List<OrganizationalContact> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<OrganizationalContact> authors) {
        this.authors = authors;
    }

    public OrganizationalEntity getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(OrganizationalEntity manufacturer) {
        this.manufacturer = manufacturer;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.author, this.publisher, this.group, this.name, this.version, this.description, this.scope, this.hashes, this.licenses, this.copyright, this.cpe, this.purl, this.omniborId, this.swhid, this.swid, this.modified, this.components, this.evidence, this.releaseNotes, this.type, this.modelCard, this.data});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return this.modified == component.modified && Objects.equals(this.supplier, component.supplier) && Objects.equals(this.author, component.author) && Objects.equals(this.publisher, component.publisher) && Objects.equals(this.group, component.group) && Objects.equals(this.name, component.name) && Objects.equals(this.version, component.version) && Objects.equals(this.description, component.description) && Objects.equals((Object)this.scope, (Object)component.scope) && Objects.equals(this.hashes, component.hashes) && Objects.equals(this.licenses, component.licenses) && Objects.equals(this.copyright, component.copyright) && Objects.equals(this.cpe, component.cpe) && Objects.equals(this.purl, component.purl) && Objects.equals(this.swid, component.swid) && Objects.equals(this.swhid, component.swhid) && Objects.equals(this.omniborId, component.omniborId) && Objects.equals(this.components, component.components) && Objects.equals(this.evidence, component.evidence) && Objects.equals(this.mimeType, component.mimeType) && Objects.equals(this.releaseNotes, component.releaseNotes) && Objects.equals(this.data, component.data) && Objects.equals(this.modelCard, component.modelCard) && Objects.equals((Object)this.type, (Object)component.type);
    }

    public static enum Scope {
        REQUIRED("required"),
        OPTIONAL("optional"),
        EXCLUDED("excluded");

        private final String name;

        public String getScopeName() {
            return this.name;
        }

        private Scope(String name) {
            this.name = name;
        }
    }

    public static enum Type {
        APPLICATION("application"),
        FRAMEWORK("framework"),
        LIBRARY("library"),
        CONTAINER("container"),
        PLATFORM("platform"),
        OPERATING_SYSTEM("operating-system"),
        DEVICE("device"),
        DEVICE_DRIVER("device-driver"),
        FIRMWARE("firmware"),
        FILE("file"),
        MACHINE_LEARNING_MODEL("machine-learning-model"),
        DATA("data"),
        CRYPTOGRAPHIC_ASSET("cryptographic-asset");

        private final String name;

        public String getTypeName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

