/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import org.curioswitch.common.protobuf.json.CodeGenUtil;
import org.curioswitch.common.protobuf.json.LocalVariables;
import org.curioswitch.common.protobuf.json.ProtoFieldInfo;
import org.curioswitch.common.protobuf.json.SerializeSupport;
import org.curioswitch.common.protobuf.json.TypeSpecificMarshaller;
import org.curioswitch.common.protobuf.json.bytebuddy.Goto;
import org.curioswitch.common.protobuf.json.bytebuddy.IfEqual;
import org.curioswitch.common.protobuf.json.bytebuddy.IfFalse;
import org.curioswitch.common.protobuf.json.bytebuddy.IfIntsNotEqual;
import org.curioswitch.common.protobuf.json.bytebuddy.SetJumpTargetLabel;

final class DoWrite
implements ByteCodeAppender,
Implementation {
    private static final StackManipulation JsonGenerator_writeFieldName_SerializableString;
    private static final StackManipulation JsonGenerator_writeFieldName_String;
    private static final StackManipulation JsonGenerator_writeStartObject;
    private static final StackManipulation JsonGenerator_writeEndObject;
    private static final StackManipulation Object_equals;
    private static final StackManipulation EnumLite_getNumber;
    private static final StackManipulation Iterator_hasNext;
    private static final StackManipulation Iterator_next;
    private static final StackManipulation Map_Entry_getKey;
    private static final StackManipulation Map_Entry_getValue;
    private static final StackManipulation Integer_toString;
    private static final StackManipulation Long_toString;
    private static final StackManipulation Boolean_toString;
    private static final StackManipulation SerializeSupport_mapIterator;
    private static final StackManipulation SerializeSupport_printRepeatedSignedInt32;
    private static final StackManipulation SerializeSupport_printSignedInt32;
    private static final StackManipulation SerializeSupport_printRepeatedSignedInt64;
    private static final StackManipulation SerializeSupport_printSignedInt64;
    private static final StackManipulation SerializeSupport_printRepeatedBool;
    private static final StackManipulation SerializeSupport_printBool;
    private static final StackManipulation SerializeSupport_printRepeatedFloat;
    private static final StackManipulation SerializeSupport_printFloat;
    private static final StackManipulation SerializeSupport_printRepeatedDouble;
    private static final StackManipulation SerializeSupport_printDouble;
    private static final StackManipulation SerializeSupport_printRepeatedUnsignedInt32;
    private static final StackManipulation SerializeSupport_printUnsignedInt32;
    private static final StackManipulation SerializeSupport_printRepeatedUnsignedInt64;
    private static final StackManipulation SerializeSupport_printUnsignedInt64;
    private static final StackManipulation SerializeSupport_printRepeatedString;
    private static final StackManipulation SerializeSupport_printString;
    private static final StackManipulation SerializeSupport_printRepeatedBytes;
    private static final StackManipulation SerializeSupport_printBytes;
    private static final StackManipulation SerializeSupport_printRepeatedNull;
    private static final StackManipulation SerializeSupport_printNull;
    private static final StackManipulation SerializeSupport_printRepeatedEnum;
    private static final StackManipulation SerializeSupport_printEnum;
    private static final StackManipulation SerializeSupport_printRepeatedMessage;
    private static final StackManipulation SerializeSupport_printMessage;
    private static final StackManipulation SerializeSupport_normalizeUnsignedInt32;
    private static final StackManipulation SerializeSupport_normalizeUnsignedInt64;
    private final Message prototype;
    private final Class<? extends Message> messageClass;
    private final Descriptors.Descriptor descriptor;
    private final boolean includeDefaults;
    private final boolean printingEnumsAsInts;
    private final boolean sortingMapKeys;

    DoWrite(Message prototype, boolean includeDefaults, boolean printingEnumsAsInts, boolean sortingMapKeys) {
        this.prototype = prototype;
        this.messageClass = prototype.getClass();
        this.descriptor = prototype.getDescriptorForType();
        this.includeDefaults = includeDefaults;
        this.printingEnumsAsInts = printingEnumsAsInts;
        this.sortingMapKeys = sortingMapKeys;
    }

    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        StackManipulation getDefaultInstance;
        Map<String, FieldDescription> fieldsByName = CodeGenUtil.fieldsByName(implementationContext);
        ArrayList<Object> stackManipulations = new ArrayList<Object>();
        try {
            getDefaultInstance = CodeGenUtil.invoke(this.messageClass.getDeclaredMethod("getDefaultInstance", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find getDefaultInstance on a Message class.", e);
        }
        LocalVariables<LocalVariable> locals = LocalVariables.builderForMethod((MethodDescription)instrumentedMethod, (LocalVariables.VariableHandle[])LocalVariable.values()).add(Iterator.class, LocalVariable.iterator).add(Map.Entry.class, LocalVariable.entry).build();
        stackManipulations.add(locals.initialize());
        for (Descriptors.FieldDescriptor f : CodeGenUtil.sorted(this.descriptor.getFields())) {
            ProtoFieldInfo field = new ProtoFieldInfo(f, this.prototype);
            StackManipulation.Compound getValue = new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.message), CodeGenUtil.invoke(field.getValueMethod())});
            Label afterSerializeField = new Label();
            if (!this.includeDefaults || field.isInOneof() || field.descriptor().hasOptionalKeyword() || field.descriptor().isOptional() && field.valueJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                stackManipulations.add(DoWrite.checkDefaultValue(field, locals, (StackManipulation)getValue, getDefaultInstance, afterSerializeField));
            }
            stackManipulations.addAll(Arrays.asList(locals.load(LocalVariable.gen), FieldAccess.forField((FieldDescription)fieldsByName.get(CodeGenUtil.fieldNameForSerializedFieldName(field))).read(), JsonGenerator_writeFieldName_SerializableString));
            if (field.isMapField()) {
                StackManipulation keyToString;
                switch (field.mapKeyField().descriptor().getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        keyToString = Integer_toString;
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        keyToString = Long_toString;
                        break;
                    }
                    case BOOL: {
                        keyToString = Boolean_toString;
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        keyToString = new StackManipulation.Compound(new StackManipulation[]{SerializeSupport_normalizeUnsignedInt32, Long_toString});
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        keyToString = SerializeSupport_normalizeUnsignedInt64;
                        break;
                    }
                    case STRING: {
                        keyToString = StackManipulation.Trivial.INSTANCE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected map key type: " + field.mapKeyField().descriptor().getType());
                    }
                }
                Label loopStart = new Label();
                Label loopEnd = new Label();
                StackManipulation printValue = this.printValue(fieldsByName, field);
                StackManipulation.Compound printMapFieldValue = new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.gen), JsonGenerator_writeStartObject, getValue, IntegerConstant.forValue((boolean)this.sortingMapKeys), IntegerConstant.forValue((field.mapKeyField().valueType() == Descriptors.FieldDescriptor.Type.STRING ? 1 : 0) != 0), SerializeSupport_mapIterator, locals.store(LocalVariable.iterator), new SetJumpTargetLabel(loopStart), locals.load(LocalVariable.iterator), Iterator_hasNext, new IfFalse(loopEnd), locals.load(LocalVariable.iterator), Iterator_next, TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Map.Entry.class)), locals.store(LocalVariable.entry), locals.load(LocalVariable.gen), locals.load(LocalVariable.entry), Map_Entry_getKey, DoWrite.unbox(field.mapKeyField()), keyToString, JsonGenerator_writeFieldName_String, locals.load(LocalVariable.entry), Map_Entry_getValue, DoWrite.unbox(field.valueField()), locals.load(LocalVariable.gen), printValue, new Goto(loopStart), new SetJumpTargetLabel(loopEnd), locals.load(LocalVariable.gen), JsonGenerator_writeEndObject});
                stackManipulations.add(printMapFieldValue);
            } else {
                StackManipulation printValue = this.printValue(fieldsByName, field);
                stackManipulations.addAll(Arrays.asList(getValue, locals.load(LocalVariable.gen), printValue));
            }
            stackManipulations.add(new SetJumpTargetLabel(afterSerializeField));
        }
        stackManipulations.add(MethodReturn.VOID);
        StackManipulation.Size operandStackSize = new StackManipulation.Compound(stackManipulations).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(operandStackSize.getMaximalSize(), locals.stackSize());
    }

    private static StackManipulation checkDefaultValue(ProtoFieldInfo info, LocalVariables<LocalVariable> locals, StackManipulation getValue, StackManipulation getDefaultInstance, Label afterSerializeField) {
        if (info.isInOneof()) {
            return new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.message), CodeGenUtil.invoke(info.oneOfCaseMethod()), EnumLite_getNumber, IntegerConstant.forValue((int)info.descriptor().getNumber()), new IfIntsNotEqual(afterSerializeField)});
        }
        if (!info.isRepeated()) {
            switch (info.valueJavaType()) {
                case INT: {
                    return DoWrite.checkPrimitiveDefault(getValue, IntegerConstant.forValue((int)((Integer)info.descriptor().getDefaultValue())), Integer.TYPE, afterSerializeField);
                }
                case LONG: {
                    return DoWrite.checkPrimitiveDefault(getValue, LongConstant.forValue((long)((Long)info.descriptor().getDefaultValue())), Long.TYPE, afterSerializeField);
                }
                case FLOAT: {
                    return DoWrite.checkPrimitiveDefault(getValue, FloatConstant.forValue((float)((Float)info.descriptor().getDefaultValue()).floatValue()), Float.TYPE, afterSerializeField);
                }
                case DOUBLE: {
                    return DoWrite.checkPrimitiveDefault(getValue, DoubleConstant.forValue((double)((Double)info.descriptor().getDefaultValue())), Double.TYPE, afterSerializeField);
                }
                case BOOLEAN: {
                    return DoWrite.checkPrimitiveDefault(getValue, IntegerConstant.forValue((boolean)((Boolean)info.descriptor().getDefaultValue())), Boolean.TYPE, afterSerializeField);
                }
                case ENUM: {
                    return DoWrite.checkPrimitiveDefault(getValue, IntegerConstant.forValue((int)((Descriptors.EnumValueDescriptor)info.descriptor().getDefaultValue()).getNumber()), Integer.TYPE, afterSerializeField);
                }
                case STRING: {
                    return new StackManipulation.Compound(new StackManipulation[]{getValue, new TextConstant((String)info.descriptor().getDefaultValue()), Object_equals, new IfEqual(Object.class, afterSerializeField)});
                }
                case BYTE_STRING: {
                    return new StackManipulation.Compound(new StackManipulation[]{getValue, getDefaultInstance, CodeGenUtil.invoke(info.getValueMethod()), Object_equals, new IfEqual(Object.class, afterSerializeField)});
                }
                case MESSAGE: {
                    return new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.message), CodeGenUtil.invoke(info.hasValueMethod()), new IfFalse(afterSerializeField)});
                }
            }
            throw new IllegalStateException("Unknown JavaType: " + info.valueJavaType());
        }
        return new StackManipulation.Compound(new StackManipulation[]{locals.load(LocalVariable.message), CodeGenUtil.invoke(info.repeatedValueCountMethod()), new IfFalse(afterSerializeField)});
    }

    private static StackManipulation unbox(ProtoFieldInfo field) {
        switch (field.valueJavaType()) {
            case INT: 
            case ENUM: {
                return new StackManipulation.Compound(new StackManipulation[]{TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Integer.class)), PrimitiveUnboxingDelegate.INTEGER});
            }
            case LONG: {
                return new StackManipulation.Compound(new StackManipulation[]{TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Long.class)), PrimitiveUnboxingDelegate.LONG});
            }
            case BOOLEAN: {
                return new StackManipulation.Compound(new StackManipulation[]{TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Boolean.class)), PrimitiveUnboxingDelegate.BOOLEAN});
            }
            case FLOAT: {
                return new StackManipulation.Compound(new StackManipulation[]{TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Float.class)), PrimitiveUnboxingDelegate.FLOAT});
            }
            case DOUBLE: {
                return new StackManipulation.Compound(new StackManipulation[]{TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Double.class)), PrimitiveUnboxingDelegate.DOUBLE});
            }
            case STRING: {
                return TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(String.class));
            }
            case BYTE_STRING: {
                return TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(ByteString.class));
            }
            case MESSAGE: {
                return TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Message.class));
            }
        }
        throw new IllegalStateException("Unknown field type.");
    }

    private StackManipulation printValue(Map<String, FieldDescription> fieldsByName, ProtoFieldInfo info) {
        boolean repeated = !info.isMapField() && info.isRepeated();
        switch (info.valueType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                return repeated ? SerializeSupport_printRepeatedSignedInt32 : SerializeSupport_printSignedInt32;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                return repeated ? SerializeSupport_printRepeatedSignedInt64 : SerializeSupport_printSignedInt64;
            }
            case BOOL: {
                return repeated ? SerializeSupport_printRepeatedBool : SerializeSupport_printBool;
            }
            case FLOAT: {
                return repeated ? SerializeSupport_printRepeatedFloat : SerializeSupport_printFloat;
            }
            case DOUBLE: {
                return repeated ? SerializeSupport_printRepeatedDouble : SerializeSupport_printDouble;
            }
            case UINT32: 
            case FIXED32: {
                return repeated ? SerializeSupport_printRepeatedUnsignedInt32 : SerializeSupport_printUnsignedInt32;
            }
            case UINT64: 
            case FIXED64: {
                return repeated ? SerializeSupport_printRepeatedUnsignedInt64 : SerializeSupport_printUnsignedInt64;
            }
            case STRING: {
                return repeated ? SerializeSupport_printRepeatedString : SerializeSupport_printString;
            }
            case BYTES: {
                return repeated ? SerializeSupport_printRepeatedBytes : SerializeSupport_printBytes;
            }
            case ENUM: {
                if (info.valueField().descriptor().getEnumType().equals(NullValue.getDescriptor())) {
                    return repeated ? SerializeSupport_printRepeatedNull : SerializeSupport_printNull;
                }
                if (this.printingEnumsAsInts) {
                    return repeated ? SerializeSupport_printRepeatedUnsignedInt32 : SerializeSupport_printUnsignedInt32;
                }
                return new StackManipulation.Compound(new StackManipulation[]{CodeGenUtil.getEnumDescriptor(info), repeated ? SerializeSupport_printRepeatedEnum : SerializeSupport_printEnum});
            }
            case MESSAGE: 
            case GROUP: {
                return new StackManipulation.Compound(new StackManipulation[]{FieldAccess.forField((FieldDescription)fieldsByName.get(CodeGenUtil.fieldNameForNestedMarshaller(info.valueField().descriptor().getMessageType()))).read(), repeated ? SerializeSupport_printRepeatedMessage : SerializeSupport_printMessage});
            }
        }
        throw new IllegalStateException("Unknown field type.");
    }

    private static StackManipulation checkPrimitiveDefault(StackManipulation getValue, StackManipulation loadDefault, Class<?> variableType, Label afterPrint) {
        return new StackManipulation.Compound(new StackManipulation[]{getValue, loadDefault, new IfEqual(variableType, afterPrint)});
    }

    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return this;
    }

    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    static {
        try {
            JsonGenerator_writeFieldName_SerializableString = CodeGenUtil.invoke(JsonGenerator.class.getDeclaredMethod("writeFieldName", SerializableString.class));
            JsonGenerator_writeFieldName_String = CodeGenUtil.invoke(JsonGenerator.class.getDeclaredMethod("writeFieldName", String.class));
            JsonGenerator_writeStartObject = CodeGenUtil.invoke(JsonGenerator.class.getDeclaredMethod("writeStartObject", new Class[0]));
            JsonGenerator_writeEndObject = CodeGenUtil.invoke(JsonGenerator.class.getDeclaredMethod("writeEndObject", new Class[0]));
            Object_equals = CodeGenUtil.invoke(Object.class.getDeclaredMethod("equals", Object.class));
            EnumLite_getNumber = CodeGenUtil.invoke(Internal.EnumLite.class.getDeclaredMethod("getNumber", new Class[0]));
            Integer_toString = CodeGenUtil.invoke(Integer.class.getDeclaredMethod("toString", Integer.TYPE));
            Long_toString = CodeGenUtil.invoke(Long.class.getDeclaredMethod("toString", Long.TYPE));
            Boolean_toString = CodeGenUtil.invoke(Boolean.class.getDeclaredMethod("toString", Boolean.TYPE));
            Iterator_hasNext = CodeGenUtil.invoke(Iterator.class.getDeclaredMethod("hasNext", new Class[0]));
            Iterator_next = CodeGenUtil.invoke(Iterator.class.getDeclaredMethod("next", new Class[0]));
            Map_Entry_getKey = CodeGenUtil.invoke(Map.Entry.class.getDeclaredMethod("getKey", new Class[0]));
            Map_Entry_getValue = CodeGenUtil.invoke(Map.Entry.class.getDeclaredMethod("getValue", new Class[0]));
            SerializeSupport_mapIterator = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("mapIterator", Map.class, Boolean.TYPE, Boolean.TYPE));
            SerializeSupport_printRepeatedSignedInt32 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedSignedInt32", List.class, JsonGenerator.class));
            SerializeSupport_printSignedInt32 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printSignedInt32", Integer.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedSignedInt64 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedSignedInt64", List.class, JsonGenerator.class));
            SerializeSupport_printSignedInt64 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printSignedInt64", Long.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedBool = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedBool", List.class, JsonGenerator.class));
            SerializeSupport_printBool = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printBool", Boolean.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedFloat = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedFloat", List.class, JsonGenerator.class));
            SerializeSupport_printFloat = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printFloat", Float.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedDouble = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedDouble", List.class, JsonGenerator.class));
            SerializeSupport_printDouble = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printDouble", Double.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedUnsignedInt32 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedUnsignedInt32", List.class, JsonGenerator.class));
            SerializeSupport_printUnsignedInt32 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printUnsignedInt32", Integer.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedUnsignedInt64 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedUnsignedInt64", List.class, JsonGenerator.class));
            SerializeSupport_printUnsignedInt64 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printUnsignedInt64", Long.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedString = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedString", List.class, JsonGenerator.class));
            SerializeSupport_printString = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printString", String.class, JsonGenerator.class));
            SerializeSupport_printRepeatedBytes = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedBytes", List.class, JsonGenerator.class));
            SerializeSupport_printBytes = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printBytes", ByteString.class, JsonGenerator.class));
            SerializeSupport_printRepeatedNull = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedNull", List.class, JsonGenerator.class));
            SerializeSupport_printNull = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printNull", Integer.TYPE, JsonGenerator.class));
            SerializeSupport_printRepeatedEnum = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedEnum", List.class, JsonGenerator.class, Descriptors.EnumDescriptor.class));
            SerializeSupport_printEnum = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printEnum", Integer.TYPE, JsonGenerator.class, Descriptors.EnumDescriptor.class));
            SerializeSupport_printRepeatedMessage = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printRepeatedMessage", List.class, JsonGenerator.class, TypeSpecificMarshaller.class));
            SerializeSupport_printMessage = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("printMessage", Message.class, JsonGenerator.class, TypeSpecificMarshaller.class));
            SerializeSupport_normalizeUnsignedInt32 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("normalizeUnsignedInt32", Integer.TYPE));
            SerializeSupport_normalizeUnsignedInt64 = CodeGenUtil.invoke(SerializeSupport.class.getDeclaredMethod("normalizeUnsignedInt64", Long.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static enum LocalVariable implements LocalVariables.VariableHandle
    {
        message,
        gen,
        iterator,
        entry;

    }
}

