/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class Resolver {
    private File file;
    private URI uri;
    private InputStream is;
    private URL url;

    public Resolver(String path) throws IOException {
        this("", path);
    }

    public Resolver(String baseUriStr, String uriStr) throws IOException {
        System.out.println("Resovling. Base: " + baseUriStr + ", URI: " + uriStr);
        if (uriStr.startsWith("classpath:")) {
            this.tryClasspath(uriStr);
        } else {
            this.tryFileSystem(baseUriStr, uriStr);
        }
        if (this.is == null) {
            String msg = "Could not find resource '" + uriStr;
            if (baseUriStr != null) {
                msg = msg + "' relative to '" + baseUriStr + "'";
            }
            throw new IOException(msg);
        }
    }

    private void tryFileSystem(String baseUriStr, String uriStr) throws IOException, MalformedURLException {
        if (uriStr.startsWith("file:")) {
            uriStr = new URL(URLDecoder.decode(uriStr, "utf-8")).getFile();
        }
        try {
            File uriFile = new File(uriStr);
            uriFile = new File(uriFile.getAbsolutePath());
            URI relative = uriFile.exists() ? uriFile.toURI() : new URI(uriStr);
            if (relative.isAbsolute()) {
                this.uri = relative;
                this.url = relative.toURL();
                this.is = this.url.openStream();
            } else if (baseUriStr != null) {
                File baseFile = new File(baseUriStr);
                if (!baseFile.exists() && baseUriStr.startsWith("file:/")) {
                    baseFile = new File(baseUriStr.substring(6));
                }
                URI base = baseFile.exists() ? baseFile.toURI() : new URI(baseUriStr);
                if ((base = base.resolve(relative)).isAbsolute()) {
                    this.url = base.toURL();
                    this.is = this.url.openStream();
                    this.uri = base;
                }
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (this.uri != null && "file".equals(this.uri.getScheme())) {
            this.file = new File(this.uri);
        }
        if (this.is == null && this.file != null && this.file.exists()) {
            this.uri = this.file.toURI();
            this.url = this.file.toURL();
            try {
                this.is = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new XFireRuntimeException("File was deleted! " + uriStr, e);
            }
        } else if (this.is == null) {
            this.tryClasspath(uriStr);
        }
    }

    private void tryClasspath(String uriStr) throws IOException {
        URL url;
        if (uriStr.startsWith("classpath:")) {
            uriStr = uriStr.substring(10);
        }
        if ((url = ClassLoaderUtils.getResource(uriStr, this.getClass())) == null) {
            this.tryRemote(uriStr);
        } else {
            try {
                String decodedURL = url.toString();
                this.uri = new URI(URLEncoder.encode(decodedURL, "UTF-8"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.is = url.openStream();
            this.url = url;
        }
    }

    private void tryRemote(String uriStr) throws IOException {
        try {
            URL url;
            this.url = url = new URL(uriStr);
            this.uri = new URI(url.toString());
            this.is = url.openStream();
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public URL getURL() {
        return this.url;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public boolean isFile() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }
}

