/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.server.http;

import java.io.File;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.server.XFireServer;
import org.codehaus.xfire.transport.http.XFireServlet;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SslListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;

public class XFireHttpServer
implements XFireServer {
    private Server httpServer;
    private int port = 8081;
    private XFire xfire;
    private File keystore;
    private String keystorePassword;
    private String keyPassword;

    public XFireHttpServer() {
    }

    public XFireHttpServer(File keystore, String keystorePassword, String keyPassword) {
        this(XFireFactory.newInstance().getXFire(), keystore, keystorePassword, keyPassword);
    }

    public XFireHttpServer(XFire xfire, File keystore, String keystorePassword, String keyPassword) {
        this.xfire = xfire;
        this.keystore = keystore;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
    }

    public XFireHttpServer(XFire xfire) {
        this.xfire = xfire;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.httpServer = new Server();
        if (this.keystore != null) {
            SslListener listener = new SslListener(new InetAddrPort(this.port));
            listener.setKeystore(this.keystore.getAbsolutePath());
            listener.setKeyPassword(this.keystorePassword);
            listener.setPassword(this.keyPassword);
            this.httpServer.addListener((HttpListener)listener);
        } else {
            this.httpServer.addListener(new InetAddrPort(this.port));
        }
        HttpContext context = this.httpServer.getContext("/");
        context.setRequestLog(null);
        ServletHandler handler = new ServletHandler();
        handler.addServlet("XFireServlet", "/*", XFireServlet.class.getName());
        if (this.xfire != null) {
            handler.getServletContext().setAttribute("xfire.instance", (Object)this.xfire);
        }
        context.addHandler((HttpHandler)handler);
        this.httpServer.start();
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            this.httpServer.stop();
            this.httpServer = null;
        }
    }

    public boolean isStarted() {
        return this.httpServer != null && this.httpServer.isStarted();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        this.port = value;
    }
}

