/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient;

import javax.annotation.Nullable;
import org.sonar.wsclient.internal.HttpRequestFactory;
import org.sonar.wsclient.issue.ActionPlanClient;
import org.sonar.wsclient.issue.IssueClient;
import org.sonar.wsclient.issue.internal.DefaultActionPlanClient;
import org.sonar.wsclient.issue.internal.DefaultIssueClient;
import org.sonar.wsclient.permissions.PermissionClient;
import org.sonar.wsclient.permissions.internal.DefaultPermissionClient;
import org.sonar.wsclient.project.ProjectClient;
import org.sonar.wsclient.project.internal.DefaultProjectClient;
import org.sonar.wsclient.qualitygate.QualityGateClient;
import org.sonar.wsclient.qualitygate.internal.DefaultQualityGateClient;
import org.sonar.wsclient.rule.RuleClient;
import org.sonar.wsclient.rule.RuleTagClient;
import org.sonar.wsclient.rule.internal.DefaultRuleClient;
import org.sonar.wsclient.rule.internal.DefaultRuleTagClient;
import org.sonar.wsclient.system.SystemClient;
import org.sonar.wsclient.system.internal.DefaultSystemClient;
import org.sonar.wsclient.user.UserClient;
import org.sonar.wsclient.user.internal.DefaultUserClient;

public class SonarClient {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    final HttpRequestFactory requestFactory;

    private SonarClient(Builder builder) {
        this.requestFactory = new HttpRequestFactory(builder.url).setLogin(builder.login).setPassword(builder.password).setProxyHost(builder.proxyHost).setProxyPort(builder.proxyPort).setProxyLogin(builder.proxyLogin).setProxyPassword(builder.proxyPassword).setConnectTimeoutInMilliseconds(builder.connectTimeoutMs).setReadTimeoutInMilliseconds(builder.readTimeoutMs);
    }

    public IssueClient issueClient() {
        return new DefaultIssueClient(this.requestFactory);
    }

    public ActionPlanClient actionPlanClient() {
        return new DefaultActionPlanClient(this.requestFactory);
    }

    public UserClient userClient() {
        return new DefaultUserClient(this.requestFactory);
    }

    public PermissionClient permissionClient() {
        return new DefaultPermissionClient(this.requestFactory);
    }

    public ProjectClient projectClient() {
        return new DefaultProjectClient(this.requestFactory);
    }

    public RuleTagClient ruleTagClient() {
        return new DefaultRuleTagClient(this.requestFactory);
    }

    public RuleClient ruleClient() {
        return new DefaultRuleClient(this.requestFactory);
    }

    public QualityGateClient qualityGateClient() {
        return new DefaultQualityGateClient(this.requestFactory);
    }

    public SystemClient systemClient() {
        return new DefaultSystemClient(this.requestFactory);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SonarClient create(String serverUrl) {
        return SonarClient.builder().url(serverUrl).build();
    }

    public static class Builder {
        private String login;
        private String password;
        private String url;
        private String proxyHost;
        private String proxyLogin;
        private String proxyPassword;
        private int proxyPort = 0;
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 60000;

        private Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder login(@Nullable String login) {
            this.login = login;
            return this;
        }

        public Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder proxy(@Nullable String proxyHost, int proxyPort) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder proxyLogin(@Nullable String proxyLogin) {
            this.proxyLogin = proxyLogin;
            return this;
        }

        public Builder proxyPassword(@Nullable String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder connectTimeoutMilliseconds(int i) {
            this.connectTimeoutMs = i;
            return this;
        }

        public Builder readTimeoutMilliseconds(int i) {
            this.readTimeoutMs = i;
            return this;
        }

        public SonarClient build() {
            if (this.url == null || "".equals(this.url)) {
                throw new IllegalStateException("Server URL must be set");
            }
            return new SonarClient(this);
        }
    }
}

