/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.wsclient.jsonsimple.JSONObject;
import org.sonar.wsclient.jsonsimple.JSONValue;
import org.sonar.wsclient.services.WSUtils;
import org.sonar.wsclient.unmarshallers.JsonUtils;

public final class JdkUtils
extends WSUtils {
    @Override
    public String format(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    @Override
    public String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported", e);
        }
    }

    @Override
    public Object getField(Object json, String field) {
        return ((JSONObject)json).get(field);
    }

    @Override
    @CheckForNull
    public String getString(Object json, String field) {
        return JsonUtils.getString((JSONObject)json, field);
    }

    @Override
    @CheckForNull
    public Boolean getBoolean(Object json, String field) {
        return JsonUtils.getBoolean((JSONObject)json, field);
    }

    @Override
    @CheckForNull
    public Integer getInteger(Object json, String field) {
        return JsonUtils.getInteger((JSONObject)json, field);
    }

    @Override
    @CheckForNull
    public Double getDouble(Object json, String field) {
        return JsonUtils.getDouble((JSONObject)json, field);
    }

    @Override
    @CheckForNull
    public Long getLong(Object json, String field) {
        return JsonUtils.getLong((JSONObject)json, field);
    }

    @Override
    @CheckForNull
    public Date getDateTime(Object json, String field) {
        return JsonUtils.getDateTime((JSONObject)json, field);
    }

    @Override
    public int getArraySize(Object array) {
        return ((ArrayList)array).size();
    }

    @Override
    public Object getArrayElement(Object array, int i) {
        return ((ArrayList)array).get(i);
    }

    @Override
    public Object parse(String jsonStr) {
        return JSONValue.parse(jsonStr);
    }

    @Override
    public Set<String> getFields(Object json) {
        return ((JSONObject)json).keySet();
    }
}

