/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class ArchiveEntry {
    public static final String ROLE = ArchiveEntry.class.getName();
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    private PlexusIoResource resource;
    private String name;
    private int type;
    private int mode;

    private ArchiveEntry(String name, PlexusIoResource resource, int type, int mode) {
        this.name = name;
        this.resource = resource;
        this.type = type;
        this.mode = mode & 0xFFF | (type == 1 ? 32768 : 16384);
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        if (this.resource instanceof PlexusIoFileResource) {
            return ((PlexusIoFileResource)this.resource).getFile();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getContents();
    }

    public int getType() {
        return this.type;
    }

    public int getMode() {
        return this.mode;
    }

    public static ArchiveEntry createFileEntry(String target, PlexusIoResource resource, int permissions) throws ArchiverException {
        if (resource.isDirectory()) {
            throw new ArchiverException("Not a file: " + resource.getName());
        }
        return new ArchiveEntry(target, resource, 1, permissions);
    }

    public static ArchiveEntry createFileEntry(String target, File file, int permissions) throws ArchiverException {
        if (!file.isFile()) {
            throw new ArchiverException("Not a file: " + file);
        }
        PlexusIoFileResource res = new PlexusIoFileResource(file);
        return new ArchiveEntry(target, (PlexusIoResource)res, 1, permissions);
    }

    public static ArchiveEntry createDirectoryEntry(String target, PlexusIoResource resource, int permissions) throws ArchiverException {
        if (!resource.isDirectory()) {
            throw new ArchiverException("Not a directory: " + resource.getName());
        }
        return new ArchiveEntry(target, resource, 2, permissions);
    }

    public static ArchiveEntry createDirectoryEntry(String target, File file, int permissions) throws ArchiverException {
        if (!file.isDirectory()) {
            throw new ArchiverException("Not a directory: " + file);
        }
        PlexusIoFileResource res = new PlexusIoFileResource(file);
        return new ArchiveEntry(target, (PlexusIoResource)res, 2, permissions);
    }

    public static ArchiveEntry createEntry(String target, File file, int filePerm, int dirPerm) throws ArchiverException {
        if (file.isDirectory()) {
            return ArchiveEntry.createDirectoryEntry(target, file, dirPerm);
        }
        if (file.isFile()) {
            return ArchiveEntry.createFileEntry(target, file, filePerm);
        }
        throw new ArchiverException("Neither a file nor a directory: " + file);
    }

    public PlexusIoResource getResource() {
        return this.resource;
    }
}

