/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.recording.ChangeRecord;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.recording.DefaultChangeRecord;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="unlock-snapshots", threadSafe=true)
public class UnlockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private static final Pattern TIMESTAMPED_SNAPSHOT_REGEX = Pattern.compile("-(\\d{8}\\.\\d{6})-(\\d+)$");

    @Inject
    public UnlockSnapshotsMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.unlockSnapshots(pom, dependencyManagement.getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY_MANAGEMENT);
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.unlockSnapshots(pom, this.getProject().getDependencies(), ChangeRecord.ChangeKind.DEPENDENCY);
            }
            if (this.getProject().getParent() != null && this.isProcessingParent()) {
                this.unlockParentSnapshot(pom, this.getProject().getParent());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void unlockSnapshots(ModifiedPomXMLEventReader pom, List<Dependency> dependencies, ChangeRecord.ChangeKind changeKind) throws XMLStreamException, MojoExecutionException {
        for (Dependency dep : dependencies) {
            String version;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (this.isHandledByProperty(dep)) {
                this.getLog().debug((CharSequence)("Ignoring dependency with property as version: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length()) continue;
            String unlockedVersion = versionMatcher.replaceFirst("-SNAPSHOT");
            if (!PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)pom, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getVersion(), (String)unlockedVersion, (Model)this.getProject().getModel())) continue;
            this.getChangeRecorder().recordChange(DefaultChangeRecord.builder().withKind(changeKind).withDependency(dep).withNewVersion(unlockedVersion).build());
            this.getLog().info((CharSequence)("Unlocked " + this.toString(dep) + " to version " + unlockedVersion));
        }
    }

    private void unlockParentSnapshot(ModifiedPomXMLEventReader pom, MavenProject parent) throws XMLStreamException, MojoExecutionException {
        String unlockedParentVersion;
        if (parent == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(parent)) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        Artifact parentArtifact = parent.getArtifact();
        String parentVersion = parentArtifact.getVersion();
        Matcher versionMatcher = TIMESTAMPED_SNAPSHOT_REGEX.matcher(parentVersion);
        if (versionMatcher.find() && versionMatcher.end() == parentVersion.length() && PomHelper.setProjectParentVersion((ModifiedPomXMLEventReader)pom, (String)(unlockedParentVersion = versionMatcher.replaceFirst("-SNAPSHOT")))) {
            this.getLog().info((CharSequence)("Unlocked parent " + parentArtifact + " to version " + unlockedParentVersion));
            this.getChangeRecorder().recordChange(DefaultChangeRecord.builder().withKind(ChangeRecord.ChangeKind.PARENT).withArtifact(parentArtifact).withNewVersion(unlockedParentVersion).build());
        }
    }
}

