/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Embedded;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.tomcat.AbstractRunMojo;

public class RunMojo
extends AbstractRunMojo {
    private File classesDir;
    private Set<Artifact> dependencies;
    private File warSourceDirectory;
    private File contextFile;

    protected Context createContext(Embedded container) throws IOException {
        Context context = super.createContext(container);
        context.setReloadable(true);
        return context;
    }

    protected WebappLoader createWebappLoader() throws IOException {
        WebappLoader loader = super.createWebappLoader();
        if (this.classesDir != null) {
            loader.addRepository(this.classesDir.toURL().toString());
        }
        if (this.dependencies != null) {
            for (Artifact artifact : this.dependencies) {
                String scope = artifact.getScope();
                if ("provided".equals(scope) || "test".equals(scope)) continue;
                this.getLog().debug((CharSequence)(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getScope()));
                loader.addRepository(artifact.getFile().toURL().toString());
            }
        }
        return loader;
    }

    protected File getDocBase() {
        return this.warSourceDirectory;
    }

    protected File getContextFile() {
        return this.contextFile;
    }
}

