/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.ounce.AbstractOunceMojo;
import org.codehaus.mojo.ounce.core.OunceCore;
import org.codehaus.mojo.ounce.core.OunceCoreApplication;
import org.codehaus.mojo.ounce.core.OunceCoreException;
import org.codehaus.mojo.ounce.core.OunceProjectBean;
import org.codehaus.mojo.ounce.utils.ExternalApplication;
import org.codehaus.mojo.ounce.utils.ProjectFileInfo;
import org.codehaus.mojo.ounce.utils.Utils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="application", aggregator=true, defaultPhase=LifecyclePhase.PACKAGE)
public class ApplicationMojo
extends AbstractOunceMojo {
    @Parameter(property="reactorProjects", required=true, readonly=true)
    private List<MavenProject> projects;
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter
    protected List externalProjects;
    @Parameter
    protected List externalApplications;
    @Parameter(property="ounce.projectDir", defaultValue="${basedir}")
    private String projectDir;
    @Parameter(property="ounce.appDir", defaultValue="${basedir}")
    private String appDir;
    @Parameter(property="ounce.appName", defaultValue="${project.artifactId}")
    private String appName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isThisTheExecutionRoot()) {
            return;
        }
        try {
            OunceCore core = this.getCore();
            List coreProjects = this.getIncludedModules();
            List externs = this.getExternalProjects();
            if (externs != null) {
                if (coreProjects != null) {
                    coreProjects.addAll(externs);
                } else {
                    coreProjects = externs;
                }
            }
            if ((externs = this.getIncludedExternalApplicationProjects(core)) != null) {
                coreProjects.addAll(externs);
            }
            this.getLog().debug((CharSequence)("AppMojo: Application directory is " + this.appDir));
            core.createApplication(this.appDir, this.appName, this.appDir, coreProjects, this.options, this.getLog());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to lookup the core interface for hint: " + this.coreHint, (Exception)((Object)e));
        }
        catch (OunceCoreException e) {
            throw new MojoExecutionException("Nested Ouncecore exception: " + e.getLocalizedMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Nested IOexception: " + e.getLocalizedMessage(), (Exception)e);
        }
    }

    private List getSelectedModules(List theProjects, String[] includes, String[] excludes) throws IOException {
        IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
        if (excludes != null && excludes.length > 0) {
            selector.setExcludes(excludes);
        }
        if (includes != null && includes.length > 0) {
            selector.setIncludes(includes);
        }
        ArrayList<MavenProject> coreProjects = new ArrayList<MavenProject>(theProjects.size());
        for (MavenProject prj : theProjects) {
            File prjt = null;
            if (!this.projectDir.isEmpty()) {
                prjt = new File(this.getProjectRoot());
            } else {
                prjt = prj.getBasedir();
                this.getLog().debug((CharSequence)"AppMojo: else");
            }
            this.getLog().debug((CharSequence)("AppMojo: Project Directory: " + prjt));
            if (!selector.isSelected((FileInfo)new ProjectFileInfo(prjt)) && prj != this.project) continue;
            coreProjects.add(prj);
        }
        return coreProjects;
    }

    protected List getIncludedModules() throws IOException {
        String[] preFilterIncludes = new String[]{"**/" + this.project.getBasedir().getParentFile().getName() + "/**"};
        List preFilteredProjects = this.getSelectedModules(this.projects, preFilterIncludes, null);
        List includedProjects = this.getSelectedModules(preFilteredProjects, this.includes, this.excludes);
        includedProjects = this.getSelectedModules(this.projects, this.includes, this.excludes);
        return this.convertToBeans(includedProjects);
    }

    private List<OunceProjectBean> convertToBeans(List<OunceProjectBean> theProjects) {
        ArrayList<OunceProjectBean> beanProjects = new ArrayList<OunceProjectBean>(theProjects.size());
        for (MavenProject mavenProject : theProjects) {
            if (!this.skipPoms || !mavenProject.getPackaging().equalsIgnoreCase("pom")) {
                beanProjects.add(new OunceProjectBean(this.projectDir, this.name));
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping Pom: " + mavenProject.getArtifactId()));
        }
        return beanProjects;
    }

    protected List getExternalProjects() throws MojoExecutionException {
        ArrayList<OunceProjectBean> externals = null;
        if (this.externalProjects != null && this.externalProjects.size() > 0) {
            externals = new ArrayList<OunceProjectBean>(this.externalProjects.size());
            for (String extern : this.externalProjects) {
                String[] prj = extern.split(",");
                if (prj.length == 2) {
                    externals.add(new OunceProjectBean(prj[1], prj[0]));
                    continue;
                }
                throw new MojoExecutionException("Invalid External Project String: " + extern);
            }
        }
        return externals;
    }

    protected List getExternalApplications() throws MojoExecutionException {
        ArrayList<ExternalApplication> externals = null;
        if (this.externalApplications != null && this.externalApplications.size() > 0) {
            externals = new ArrayList(this.externalApplications.size());
            for (String extern : this.externalApplications) {
                String[] prj = extern.split(",");
                if (prj.length == 3) {
                    externals.add(new ExternalApplication(prj[0], prj[1], prj[2]));
                    continue;
                }
                if (prj.length == 2) {
                    externals.add(new ExternalApplication(prj[0], prj[1], null));
                    continue;
                }
                if (prj.length == 1) {
                    externals.add(new ExternalApplication(prj[0], null, null));
                    continue;
                }
                throw new MojoExecutionException("Invalid External Application String: " + extern);
            }
        } else {
            externals = new ArrayList<ExternalApplication>();
        }
        return externals;
    }

    public List getIncludedExternalApplicationProjects(OunceCore core) throws MojoExecutionException, OunceCoreException, IOException {
        List externalApps = this.getExternalApplications();
        ArrayList results = new ArrayList(externalApps.size());
        for (ExternalApplication extern : externalApps) {
            this.getLog().debug((CharSequence)("Reading External Application: " + extern.getPath()));
            OunceCoreApplication app = core.readApplication(extern.getPath(), this.getLog());
            results.addAll(this.filterExternalApplicationProjects(app, extern));
        }
        return results;
    }

    public List filterExternalApplicationProjects(OunceCoreApplication app, ExternalApplication extern) throws IOException {
        ArrayList<OunceProjectBean> results = new ArrayList<OunceProjectBean>();
        if (app != null && app.getProjects() != null) {
            IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
            String excludeString = extern.getExcludes();
            String includeString = extern.getIncludes();
            if (StringUtils.isNotEmpty((String)excludeString)) {
                fileSelector.setExcludes(excludeString.split("\\x7C"));
            }
            if (StringUtils.isNotEmpty((String)includeString)) {
                fileSelector.setIncludes(includeString.split("\\x7C"));
            }
            for (OunceProjectBean prj : app.getProjects()) {
                this.getLog().debug((CharSequence)("Filtering External App Project: " + prj));
                if (!fileSelector.isSelected((FileInfo)new ProjectFileInfo(new File(prj.getPath())))) continue;
                String path = extern.getPath() + File.separator + prj.getPath();
                path = Utils.convertToVariablePath(path, this.pathVariableMap);
                this.getLog().debug((CharSequence)("AppMojo: Path after conversion: " + path));
                prj.setPath(path);
                this.getLog().debug((CharSequence)("Adding External App Project: " + prj));
                results.add(prj);
            }
        }
        return results;
    }

    public List getProjects() {
        return this.projects;
    }

    public void setProjects(List theProjects) {
        this.projects = theProjects;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] theIncludes) {
        this.includes = theIncludes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] theExcludes) {
        this.excludes = theExcludes;
    }

    public void setExternalProjects(List theExternalProjects) {
        this.externalProjects = theExternalProjects;
    }

    public void setExternalApplications(List theExternalApplications) {
        this.externalApplications = theExternalApplications;
    }

    public void setPathProperties(Map thePathProperties) {
        this.pathVariableMap = thePathProperties;
    }
}

