/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nsis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.nsis.io.ProcessOutputConsumer;
import org.codehaus.mojo.nsis.io.ProcessOutputHandler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="make", defaultPhase=LifecyclePhase.PACKAGE)
public class MakeMojo
extends AbstractMojo
implements ProcessOutputConsumer {
    @Parameter(property="nsis.makensis.bin", defaultValue="makensis", required=true)
    private String makensisBin;
    @Parameter(property="nsis.scriptfile", defaultValue="setup.nsi", required=true)
    private String scriptFile;
    @Parameter(property="nsis.output.file", defaultValue="${project.build.finalName}.exe", required=true)
    private String outputFile;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    private String classifier;
    @Component
    private MavenProjectHelper projectHelper;
    private boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validate();
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.makensisBin);
        File targetFile = MakeMojo.getOutputFile(new File(this.project.getBuild().getDirectory()), this.outputFile, this.classifier);
        File targetDirectory = targetFile.getParentFile();
        if (!targetDirectory.exists()) {
            try {
                FileUtils.forceMkdir((File)targetDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't create target directory " + targetDirectory.getAbsolutePath(), (Exception)e);
            }
        }
        String optPrefix = this.isWindows ? "/" : "-";
        commands.add(optPrefix + "X" + "OutFile " + StringUtils.quoteAndEscape((String)targetFile.getAbsolutePath(), (char)'\''));
        commands.add(optPrefix + "V2");
        commands.add(this.scriptFile);
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.directory(this.project.getBasedir());
        builder.redirectErrorStream(true);
        if (this.environmentVariables != null) {
            builder.environment().putAll(this.environmentVariables);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("directory:  " + builder.directory().getAbsolutePath()));
            this.getLog().debug((CharSequence)("commands  " + builder.command().toString()));
            if (builder.environment() != null) {
                this.getLog().debug((CharSequence)"environment variables: ");
                for (Map.Entry<String, String> entry : builder.environment().entrySet()) {
                    this.getLog().debug((CharSequence)("  " + entry.getKey() + ": " + entry.getValue()));
                }
            }
        }
        try {
            int status;
            Process process = builder.start();
            ProcessOutputHandler output = new ProcessOutputHandler(process.getInputStream(), this);
            output.startThread();
            try {
                status = process.waitFor();
            }
            catch (InterruptedException e) {
                status = process.exitValue();
            }
            output.setDone(true);
            if (status != 0) {
                throw new MojoExecutionException("Execution of makensis compiler failed. See output above for details.");
            }
            this.projectHelper.attachArtifact(this.project, "exe", this.classifier, targetFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute makensis", (Exception)e);
        }
    }

    public void consumeOutputLine(String line) {
        this.getLog().info((CharSequence)("[MAKENSIS] " + line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void validate() throws MojoFailureException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.scriptFile));
            String line = reader.readLine();
            while (line != null) {
                if (line.trim().startsWith("OutFile ")) {
                    this.getLog().warn((CharSequence)"setupScript contains the property 'OutFile'. Please move this setting to the plugin-configuration");
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
            IOUtil.close(reader);
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
    }

    protected static File getOutputFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        int extensionIndex = finalName.lastIndexOf(46);
        return new File(basedir, finalName.substring(0, extensionIndex) + classifier + finalName.substring(extensionIndex));
    }
}

